/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1142")
public class MethodWithExcessiveReturnsCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAX = 3;
    @RuleProperty(description="Maximum allowed return statements per method", defaultValue="3")
    public int max = 3;
    private final Multiset<Tree> returnStatementCounter = HashMultiset.create();
    private final Deque<Tree> methods = new LinkedList<Tree>();

    public void leaveFile(JavaFileScannerContext context) {
        this.returnStatementCounter.clear();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.RETURN_STATEMENT, Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            this.returnStatementCounter.add((Object)this.methods.peek());
        } else {
            this.methods.push(tree);
        }
    }

    public void leaveNode(Tree tree) {
        IdentifierTree reportTree = null;
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            MethodTree method = (MethodTree)tree;
            if (MethodTreeUtils.isEqualsMethod(method)) {
                this.methods.pop();
            } else {
                reportTree = method.simpleName();
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION})) {
            reportTree = ((LambdaExpressionTree)tree).arrowToken();
        }
        if (reportTree != null) {
            int count = this.returnStatementCounter.count((Object)tree);
            if (count > this.max) {
                this.reportIssue((Tree)reportTree, "Reduce the number of returns of this method " + count + ", down to the maximum allowed " + this.max + ".");
            }
            this.methods.pop();
        }
    }
}

