/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5320")
public class AndroidBroadcastingCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Make sure that broadcasting intents is safe here.";
    private static final MethodMatcher SEND_BROADCAST = AndroidBroadcastingCheck.androidContext().name("sendBroadcast").withAnyParameters();
    private static final MethodMatcher SEND_BROADCAST_AS_USER = AndroidBroadcastingCheck.androidContext().name("sendBroadcastAsUser").withAnyParameters();
    private static final MethodMatcher SEND_ORDERED_BROADCAST = AndroidBroadcastingCheck.androidContext().name("sendOrderedBroadcast").withAnyParameters();
    private static final MethodMatcher SEND_ORDERED_BROADCAST_AS_USER = AndroidBroadcastingCheck.androidContext().name("sendOrderedBroadcastAsUser").withAnyParameters();
    private static final MethodMatcher SEND_STICKY_BROADCAST = AndroidBroadcastingCheck.androidContext().name("sendStickyBroadcast").withAnyParameters();
    private static final MethodMatcher SEND_STICKY_BROADCAST_AS_USER = AndroidBroadcastingCheck.androidContext().name("sendStickyBroadcastAsUser").withAnyParameters();
    private static final MethodMatcher SEND_STICKY_ORDERED_BROADCAST = AndroidBroadcastingCheck.androidContext().name("sendStickyOrderedBroadcast").withAnyParameters();
    private static final MethodMatcher SEND_STICKY_ORDERED_BROADCAST_AS_USER = AndroidBroadcastingCheck.androidContext().name("sendStickyOrderedBroadcastAsUser").withAnyParameters();
    private static final MethodMatcherCollection STICKY_BROADCAST = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{SEND_STICKY_BROADCAST, SEND_STICKY_BROADCAST_AS_USER, SEND_STICKY_ORDERED_BROADCAST, SEND_STICKY_ORDERED_BROADCAST_AS_USER});

    private static MethodMatcher androidContext() {
        return MethodMatcher.create().typeDefinition("android.content.Context");
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(SEND_BROADCAST, SEND_BROADCAST_AS_USER, SEND_ORDERED_BROADCAST, SEND_ORDERED_BROADCAST_AS_USER, SEND_STICKY_BROADCAST, SEND_STICKY_BROADCAST_AS_USER, SEND_STICKY_ORDERED_BROADCAST, SEND_STICKY_ORDERED_BROADCAST_AS_USER);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (SEND_BROADCAST.matches(mit) && (mit.arguments().size() < 2 || ((ExpressionTree)mit.arguments().get(1)).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}))) {
            this.reportIssue((Tree)mit.methodSelect(), MESSAGE);
        } else if (SEND_BROADCAST_AS_USER.matches(mit) && (mit.arguments().size() < 3 || ((ExpressionTree)mit.arguments().get(2)).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}))) {
            this.reportIssue((Tree)mit.methodSelect(), MESSAGE);
        } else if (SEND_ORDERED_BROADCAST.matches(mit) && mit.arguments().size() > 1 && ((ExpressionTree)mit.arguments().get(1)).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            this.reportIssue((Tree)mit.methodSelect(), MESSAGE);
        } else if (SEND_ORDERED_BROADCAST_AS_USER.matches(mit) && mit.arguments().size() > 2 && ((ExpressionTree)mit.arguments().get(2)).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            this.reportIssue((Tree)mit.methodSelect(), MESSAGE);
        } else if (STICKY_BROADCAST.anyMatch(mit)) {
            this.reportIssue((Tree)mit.methodSelect(), MESSAGE);
        }
    }
}

