/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public final class MethodTreeUtils {
    private MethodTreeUtils() {
    }

    public static boolean isMainMethod(MethodTree m) {
        return MethodTreeUtils.isPublic(m) && MethodTreeUtils.isStatic(m) && MethodTreeUtils.isNamed(m, "main") && MethodTreeUtils.returnsPrimitive(m, "void") && MethodTreeUtils.hasStringArrayParameter(m);
    }

    private static boolean hasStringArrayParameter(MethodTree m) {
        return m.parameters().size() == 1 && MethodTreeUtils.isParameterStringArray(m);
    }

    private static boolean isParameterStringArray(MethodTree m) {
        VariableTree variableTree = (VariableTree)m.parameters().get(0);
        boolean result = false;
        if (variableTree.type().is(new Tree.Kind[]{Tree.Kind.ARRAY_TYPE})) {
            ArrayTypeTree arrayTypeTree = (ArrayTypeTree)variableTree.type();
            result = arrayTypeTree.type().symbolType().isClass() && "String".equals(arrayTypeTree.type().symbolType().name());
        }
        return result;
    }

    public static boolean isEqualsMethod(MethodTree m) {
        boolean hasEqualsSignature = MethodTreeUtils.isNamed(m, "equals") && MethodTreeUtils.returnsPrimitive(m, "boolean") && MethodTreeUtils.hasObjectParameter(m);
        return MethodTreeUtils.isPublic(m) && !MethodTreeUtils.isStatic(m) && hasEqualsSignature;
    }

    private static boolean hasObjectParameter(MethodTree m) {
        return m.parameters().size() == 1 && ((VariableTree)m.parameters().get(0)).type().symbolType().is("java.lang.Object");
    }

    public static boolean isHashCodeMethod(MethodTree m) {
        boolean hasHashCodeSignature = MethodTreeUtils.isNamed(m, "hashCode") && m.parameters().isEmpty() && MethodTreeUtils.returnsInt(m);
        return MethodTreeUtils.isPublic(m) && !MethodTreeUtils.isStatic(m) && hasHashCodeSignature;
    }

    private static boolean isNamed(MethodTree m, String name) {
        return name.equals(m.simpleName().name());
    }

    private static boolean isStatic(MethodTree m) {
        return ModifiersUtils.hasModifier((ModifiersTree)m.modifiers(), (Modifier)Modifier.STATIC);
    }

    private static boolean isPublic(MethodTree m) {
        return ModifiersUtils.hasModifier((ModifiersTree)m.modifiers(), (Modifier)Modifier.PUBLIC);
    }

    private static boolean returnsInt(MethodTree m) {
        return MethodTreeUtils.returnsPrimitive(m, "int");
    }

    private static boolean returnsPrimitive(MethodTree m, String primitive) {
        TypeTree returnType = m.returnType();
        if (returnType == null) {
            return false;
        }
        return returnType.is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE}) && primitive.equals(((PrimitiveTypeTree)returnType).keyword().text());
    }
}

