/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4266")
public class RedundantStreamCollectCheck
extends AbstractMethodDetection {
    private static final Set<String> STREAM_TYPES = ImmutableSet.of((Object)"java.util.stream.Stream", (Object)"java.util.stream.IntStream", (Object)"java.util.stream.LongStream", (Object)"java.util.stream.DoubleStream");
    private static final MethodMatcher COUNTING = RedundantStreamCollectCheck.streamCollectorsMatcher().name("counting").withoutParameter();
    private static final MethodMatcher MAX_BY = RedundantStreamCollectCheck.streamCollectorsMatcher().name("maxBy").withAnyParameters();
    private static final MethodMatcher MIN_BY = RedundantStreamCollectCheck.streamCollectorsMatcher().name("minBy").withAnyParameters();
    private static final MethodMatcher MAPPING = RedundantStreamCollectCheck.streamCollectorsMatcher().name("mapping").withAnyParameters();
    private static final MethodMatcher REDUCING = RedundantStreamCollectCheck.streamCollectorsMatcher().name("reducing").withAnyParameters();
    private static final MethodMatcher SUMMING_INT = RedundantStreamCollectCheck.streamCollectorsMatcher().name("summingInt").withAnyParameters();
    private static final MethodMatcher SUMMING_LONG = RedundantStreamCollectCheck.streamCollectorsMatcher().name("summingLong").withAnyParameters();
    private static final MethodMatcher SUMMING_DOUBLE = RedundantStreamCollectCheck.streamCollectorsMatcher().name("summingDouble").withAnyParameters();
    private static final Map<MethodMatcher, String> REPLACEMENTS = ImmutableMap.builder().put((Object)COUNTING, (Object)"count()").put((Object)MAX_BY, (Object)"max()").put((Object)MIN_BY, (Object)"min()").put((Object)MAPPING, (Object)"map(...).collect()").put((Object)REDUCING, (Object)"reduce(...).collect()").put((Object)SUMMING_INT, (Object)"mapToInt(...).sum()").put((Object)SUMMING_LONG, (Object)"mapToLong(...).sum()").put((Object)SUMMING_DOUBLE, (Object)"mapToDouble(...).sum()").build();

    private static MethodMatcher streamCollectorsMatcher() {
        return MethodMatcher.create().typeDefinition("java.util.stream.Collectors");
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return STREAM_TYPES.stream().map(type -> MethodMatcher.create().typeDefinition(type).name("collect").addParameter("java.util.stream.Collector")).collect(Collectors.toList());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree collectMIT) {
        ExpressionTree argument = (ExpressionTree)collectMIT.arguments().get(0);
        if (argument.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree methodInvocation = (MethodInvocationTree)argument;
            REPLACEMENTS.entrySet().stream().filter(e -> ((MethodMatcher)e.getKey()).matches(methodInvocation)).findFirst().ifPresent(e -> this.context.reportIssue((JavaCheck)this, (Tree)ExpressionUtils.methodName((MethodInvocationTree)methodInvocation), "Use \"" + (String)e.getValue() + "\" instead."));
        }
    }
}

