/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3626")
public class RedundantJumpCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (methodTree.block() != null) {
            CFG cfg = CFG.build((MethodTree)methodTree);
            cfg.blocks().forEach(this::checkBlock);
        }
    }

    private void checkBlock(CFG.Block block) {
        CFG.Block successor;
        CFG.Block successorWithoutJump = block.successorWithoutJump();
        Tree terminator = block.terminator();
        if (terminator != null && successorWithoutJump != null && terminator.is(new Tree.Kind[]{Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.RETURN_STATEMENT}) && !RedundantJumpCheck.isReturnWithExpression(terminator) && !RedundantJumpCheck.isSwitchCaseChild(terminator) && (successorWithoutJump = RedundantJumpCheck.nonEmptySuccessor(successorWithoutJump)).equals(successor = RedundantJumpCheck.nonEmptySuccessor((CFG.Block)block.successors().iterator().next()))) {
            this.reportIssue(terminator, "Remove this redundant jump.");
        }
    }

    private static boolean isReturnWithExpression(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            return ((ReturnStatementTree)tree).expression() != null;
        }
        return false;
    }

    private static boolean isSwitchCaseChild(Tree tree) {
        return tree.parent().is(new Tree.Kind[]{Tree.Kind.CASE_GROUP});
    }

    private static CFG.Block nonEmptySuccessor(CFG.Block initialBlock) {
        CFG.Block result = initialBlock;
        while (result.elements().isEmpty() && result.successors().size() == 1) {
            result = (CFG.Block)result.successors().iterator().next();
        }
        return result;
    }
}

