/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3416")
public class LoggerClassCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatcherCollection LOG_FACTORIES = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("getLogger").addParameter("java.lang.Class"), MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("getLogger").addParameter("java.lang.String"), MethodMatcher.create().typeDefinition("org.apache.commons.logging.LogFactory").name("getLog").addParameter("java.lang.Class"), MethodMatcher.create().typeDefinition("org.apache.commons.logging.LogFactory").name("getLog").addParameter("java.lang.String"), MethodMatcher.create().typeDefinition("org.sonar.api.utils.log.Loggers").name("get").addParameter("java.lang.Class"), MethodMatcher.create().typeDefinition("org.sonar.api.utils.log.Loggers").name("get").addParameter("java.lang.String")});
    private static final MethodMatcher CLAZZ_GETNAME = MethodMatcher.create().typeDefinition("java.lang.Class").name("getName").withoutParameter();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        Symbol.TypeSymbol clazz = ((ClassTree)tree).symbol();
        clazz.memberSymbols().stream().filter(Symbol::isVariableSymbol).forEach(field -> this.checkField(clazz, (Symbol.VariableSymbol)field));
    }

    private void checkField(Symbol.TypeSymbol clazz, Symbol.VariableSymbol field) {
        ExpressionTree firstArg;
        Symbol classLiteral;
        VariableTree declaration = field.declaration();
        if (declaration == null) {
            return;
        }
        ExpressionTree initializer = declaration.initializer();
        if (initializer != null && initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && LOG_FACTORIES.anyMatch((MethodInvocationTree)initializer) && (classLiteral = LoggerClassCheck.classLiteral(firstArg = (ExpressionTree)((MethodInvocationTree)initializer).arguments().get(0))) != null && !clazz.equals(classLiteral)) {
            this.reportIssue((Tree)firstArg, "Update this logger to use \"" + clazz.name() + ".class\".");
        }
    }

    @CheckForNull
    private static Symbol classLiteral(ExpressionTree expression) {
        MethodInvocationTree mit;
        MemberSelectExpressionTree mset;
        if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (mset = (MemberSelectExpressionTree)expression).identifier().name().equals("class")) {
            return mset.expression().symbolType().symbol();
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && CLAZZ_GETNAME.matches((MethodInvocationTree)expression) && (mit = (MethodInvocationTree)expression).methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return LoggerClassCheck.classLiteral(((MemberSelectExpressionTree)mit.methodSelect()).expression());
        }
        return null;
    }
}

