/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2647")
public class BasicAuthCheck
extends AbstractMethodDetection {
    private static final String LANG_STRING = "java.lang.String";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition("org.apache.http.message.AbstractHttpMessage").name("setHeader").withAnyParameters(), MethodMatcher.create().typeDefinition("org.apache.http.message.AbstractHttpMessage").name("addHeader").addParameter(LANG_STRING).addParameter(LANG_STRING), MethodMatcher.create().typeDefinition("org.apache.http.message.BasicHeader").name("<init>").addParameter(LANG_STRING).addParameter(LANG_STRING), MethodMatcher.create().typeDefinition("java.net.URLConnection").name("setRequestProperty").withAnyParameters(), MethodMatcher.create().typeDefinition("java.net.URLConnection").name("addRequestProperty").withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.checkArguments(mit.arguments());
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.checkArguments(newClassTree.arguments());
    }

    private void checkArguments(Arguments arguments) {
        ExpressionTree arg;
        String authentication;
        if ("Authorization".equals(ExpressionsHelper.getConstantValueAsString((ExpressionTree)arguments.get(0)).value()) && (authentication = ExpressionsHelper.getConstantValueAsString(arg = BasicAuthCheck.mostLeft((ExpressionTree)arguments.get(1))).value()) != null && authentication.startsWith("Basic")) {
            this.reportIssue((Tree)arg, "Use a more secure method than basic authentication.");
        }
    }

    private static ExpressionTree mostLeft(ExpressionTree arg) {
        ExpressionTree res = ExpressionUtils.skipParentheses((ExpressionTree)arg);
        while (res.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            res = ExpressionUtils.skipParentheses((ExpressionTree)((BinaryExpressionTree)res).leftOperand());
        }
        return res;
    }
}

