/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="LinkToImageCheck")
public class LinkToImageCheck
extends AbstractPageCheck {
    private static final Set<String> IMG_SUFFIXES = new HashSet<String>(Arrays.asList(".GIF", ".JPG", ".JPEG", ".PNG", ".BMP"));

    @Override
    public void startElement(TagNode node) {
        if (LinkToImageCheck.isATag(node) && LinkToImageCheck.hasHrefToImage(node)) {
            this.createViolation(node, "Change this link to not directly target an image.");
        }
    }

    private static boolean isATag(TagNode node) {
        return "A".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean hasHrefToImage(TagNode node) {
        String href = node.getAttribute("href");
        return href != null && LinkToImageCheck.isPointingToAnImage(href);
    }

    private static boolean isPointingToAnImage(String target) {
        String upperTarget = target.toUpperCase(Locale.ENGLISH);
        return !upperTarget.contains("?") && IMG_SUFFIXES.stream().anyMatch(input -> input != null && upperTarget.endsWith((String)input));
    }
}

