/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="S5257")
public class LayoutTableCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode node) {
        if (LayoutTableCheck.isTable(node) && LayoutTableCheck.isLayout(node)) {
            this.createViolation(node, "Replace this layout table with a CSS layout.");
        }
    }

    private static boolean isTable(TagNode node) {
        return "TABLE".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isLayout(TagNode node) {
        String role = node.getAttribute("role");
        return role != null && ("PRESENTATION".equalsIgnoreCase(role) || "NONE".equalsIgnoreCase(role));
    }
}

