/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Attribute;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="S1829")
public class AbsoluteURICheck
extends AbstractPageCheck {
    private static final String DEFAULT_ATTRIBUTES = "a.href,applet.codebase,area.href,base.href,blockquote.cite,body.background,del.cite,form.action,frame.longdesc,frame.src,head.profile,iframe.longdesc,iframe.src,img.longdesc,img.src,img.usemap,input.src,input.usemap,ins.cite,link.href,object.classid,object.codebase,object.data,object.usemap,q.cite,script.src,audio.src,button.formaction,command.icon,embed.src,html.manifest,input.formaction,source.src,video.poster,video.src";
    private Matcher matcher = Pattern.compile("[A-Za-z0-9]*://.*").matcher("");
    @RuleProperty(key="attributes", description="Comma-separated list of tag.attributes to be checked for absolute URI.", defaultValue="a.href,applet.codebase,area.href,base.href,blockquote.cite,body.background,del.cite,form.action,frame.longdesc,frame.src,head.profile,iframe.longdesc,iframe.src,img.longdesc,img.src,img.usemap,input.src,input.usemap,ins.cite,link.href,object.classid,object.codebase,object.data,object.usemap,q.cite,script.src,audio.src,button.formaction,command.icon,embed.src,html.manifest,input.formaction,source.src,video.poster,video.src", type="TEXT")
    public String attributes = "a.href,applet.codebase,area.href,base.href,blockquote.cite,body.background,del.cite,form.action,frame.longdesc,frame.src,head.profile,iframe.longdesc,iframe.src,img.longdesc,img.src,img.usemap,input.src,input.usemap,ins.cite,link.href,object.classid,object.codebase,object.data,object.usemap,q.cite,script.src,audio.src,button.formaction,command.icon,embed.src,html.manifest,input.formaction,source.src,video.poster,video.src";
    private AbstractPageCheck.QualifiedAttribute[] attributesArray;

    @Override
    public void startDocument(List<Node> nodes) {
        this.attributesArray = this.parseAttributes(this.attributes);
    }

    @Override
    public void startElement(TagNode element) {
        for (Attribute a : this.getMatchingAttributes(element, this.attributesArray)) {
            if (!this.matcher.reset(a.getValue()).matches()) continue;
            this.createViolation(element, "Replace this absolute URI \"" + a.getName() + "\" with a relative one, or move this absolute URI to a configuration file.");
        }
    }
}

