/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.text;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.text.WriterException;

@Deprecated
public class JsonWriter
implements AutoCloseable {
    private final org.sonar.api.internal.google.gson.stream.JsonWriter stream;
    private boolean serializeEmptyStrings;

    private JsonWriter(Writer writer) {
        this.stream = new org.sonar.api.internal.google.gson.stream.JsonWriter(writer);
        this.stream.setSerializeNulls(false);
        this.stream.setLenient(false);
        this.stream.setHtmlSafe(true);
        this.serializeEmptyStrings = true;
    }

    JsonWriter(org.sonar.api.internal.google.gson.stream.JsonWriter stream) {
        this.stream = stream;
    }

    public static JsonWriter of(Writer writer) {
        return new JsonWriter(writer);
    }

    public JsonWriter setSerializeNulls(boolean b) {
        this.stream.setSerializeNulls(b);
        return this;
    }

    public JsonWriter setSerializeEmptys(boolean serializeEmptyStrings) {
        this.serializeEmptyStrings = serializeEmptyStrings;
        return this;
    }

    public JsonWriter beginArray() {
        try {
            this.stream.beginArray();
            return this;
        }
        catch (Exception e) {
            throw JsonWriter.rethrow(e);
        }
    }

    public JsonWriter endArray() {
        try {
            this.stream.endArray();
            return this;
        }
        catch (Exception e) {
            throw JsonWriter.rethrow(e);
        }
    }

    public JsonWriter beginObject() {
        try {
            this.stream.beginObject();
            return this;
        }
        catch (Exception e) {
            throw JsonWriter.rethrow(e);
        }
    }

    public JsonWriter endObject() {
        try {
            this.stream.endObject();
            return this;
        }
        catch (Exception e) {
            throw JsonWriter.rethrow(e);
        }
    }

    public JsonWriter name(String name) {
        try {
            this.stream.name(name);
            return this;
        }
        catch (Exception e) {
            throw JsonWriter.rethrow(e);
        }
    }

    public JsonWriter value(boolean value) {
        try {
            this.stream.value(value);
            return this;
        }
        catch (Exception e) {
            throw JsonWriter.rethrow(e);
        }
    }

    public JsonWriter value(double value) {
        try {
            this.stream.value(value);
            return this;
        }
        catch (Exception e) {
            throw JsonWriter.rethrow(e);
        }
    }

    public JsonWriter value(@Nullable String value) {
        try {
            this.stream.value(this.serializeEmptyStrings ? value : JsonWriter.emptyToNull(value));
            return this;
        }
        catch (Exception e) {
            throw JsonWriter.rethrow(e);
        }
    }

    public JsonWriter valueObject(@Nullable Object value) {
        try {
            if (value == null) {
                this.stream.nullValue();
                return this;
            }
            this.valueNonNullObject(value);
            return this;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw JsonWriter.rethrow(e);
        }
    }

    private void valueNonNullObject(Object value) throws IOException {
        if (value instanceof String) {
            this.stream.value(this.serializeEmptyStrings ? (String)value : JsonWriter.emptyToNull((String)value));
        } else if (value instanceof Number) {
            this.stream.value((Number)value);
        } else if (value instanceof Boolean) {
            this.stream.value((Boolean)value);
        } else if (value instanceof Date) {
            this.valueDateTime((Date)value);
        } else if (value instanceof Enum) {
            this.stream.value(((Enum)value).name());
        } else if (value instanceof Map) {
            this.stream.beginObject();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                this.stream.name(entry.getKey().toString());
                this.valueObject(entry.getValue());
            }
            this.stream.endObject();
        } else if (value instanceof Iterable) {
            this.stream.beginArray();
            for (Object o : (Iterable)value) {
                this.valueObject(o);
            }
            this.stream.endArray();
        } else {
            throw new IllegalArgumentException(String.valueOf(this.getClass()) + " does not support encoding of type: " + String.valueOf(value.getClass()));
        }
    }

    public JsonWriter values(Iterable<String> values) {
        for (String value : values) {
            this.value(value);
        }
        return this;
    }

    public JsonWriter valueDate(@Nullable Date value) {
        try {
            this.stream.value(value == null ? null : DateUtils.formatDate(value));
            return this;
        }
        catch (Exception e) {
            throw JsonWriter.rethrow(e);
        }
    }

    public JsonWriter valueDateTime(@Nullable Date value) {
        try {
            this.stream.value(value == null ? null : DateUtils.formatDateTime(value));
            return this;
        }
        catch (Exception e) {
            throw JsonWriter.rethrow(e);
        }
    }

    public JsonWriter value(long value) {
        try {
            this.stream.value(value);
            return this;
        }
        catch (Exception e) {
            throw JsonWriter.rethrow(e);
        }
    }

    public JsonWriter value(@Nullable Number value) {
        try {
            this.stream.value(value);
            return this;
        }
        catch (Exception e) {
            throw JsonWriter.rethrow(e);
        }
    }

    public JsonWriter prop(String name, @Nullable Number value) {
        return this.name(name).value(value);
    }

    public JsonWriter propDate(String name, @Nullable Date value) {
        return this.name(name).valueDate(value);
    }

    public JsonWriter propDateTime(String name, @Nullable Date value) {
        return this.name(name).valueDateTime(value);
    }

    public JsonWriter prop(String name, @Nullable String value) {
        return this.name(name).value(value);
    }

    public JsonWriter prop(String name, boolean value) {
        return this.name(name).value(value);
    }

    public JsonWriter prop(String name, long value) {
        return this.name(name).value(value);
    }

    public JsonWriter prop(String name, double value) {
        return this.name(name).value(value);
    }

    @Override
    public void close() {
        try {
            this.stream.close();
        }
        catch (Exception e) {
            throw JsonWriter.rethrow(e);
        }
    }

    private static IllegalStateException rethrow(Exception e) {
        throw new WriterException("Fail to write JSON", e);
    }

    @Nullable
    private static String emptyToNull(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value;
    }
}

