/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang3.StringUtils;
import org.sonar.api.internal.apachecommons.lang3.math.NumberUtils;
import org.sonar.api.rules.RulePriority;

public final class KeyValueFormat {
    public static final String PAIR_SEPARATOR = ";";
    public static final String FIELD_SEPARATOR = "=";

    private KeyValueFormat() {
    }

    public static StringConverter newStringConverter() {
        return StringConverter.INSTANCE;
    }

    public static ToStringConverter newToStringConverter() {
        return ToStringConverter.INSTANCE;
    }

    public static IntegerConverter newIntegerConverter() {
        return IntegerConverter.INSTANCE;
    }

    public static PriorityConverter newPriorityConverter() {
        return PriorityConverter.INSTANCE;
    }

    public static DoubleConverter newDoubleConverter() {
        return DoubleConverter.INSTANCE;
    }

    public static DateConverter newDateConverter() {
        return KeyValueFormat.newDateConverter("yyyy-MM-dd");
    }

    public static DateConverter newDateTimeConverter() {
        return KeyValueFormat.newDateConverter("yyyy-MM-dd'T'HH:mm:ssZ");
    }

    public static DateConverter newDateConverter(String format) {
        return new DateConverter(format);
    }

    public static <K, V> Map<K, V> parse(@Nullable String input, Converter<K> keyConverter, Converter<V> valueConverter) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        if (input != null) {
            FieldParser reader = new FieldParser(input);
            boolean end = false;
            while (!end) {
                String key = reader.nextKey();
                if (key == null) {
                    end = true;
                    continue;
                }
                String val = Objects.toString(reader.nextVal(), "");
                map.put(keyConverter.parse(key), valueConverter.parse(val));
            }
        }
        return map;
    }

    public static Map<String, String> parse(@Nullable String data) {
        return KeyValueFormat.parse(data, KeyValueFormat.newStringConverter(), KeyValueFormat.newStringConverter());
    }

    public static Map<String, Integer> parseStringInt(@Nullable String data) {
        return KeyValueFormat.parse(data, KeyValueFormat.newStringConverter(), KeyValueFormat.newIntegerConverter());
    }

    public static Map<String, Double> parseStringDouble(@Nullable String data) {
        return KeyValueFormat.parse(data, KeyValueFormat.newStringConverter(), KeyValueFormat.newDoubleConverter());
    }

    public static Map<Integer, String> parseIntString(@Nullable String data) {
        return KeyValueFormat.parse(data, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newStringConverter());
    }

    public static Map<Integer, Double> parseIntDouble(@Nullable String data) {
        return KeyValueFormat.parse(data, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newDoubleConverter());
    }

    public static Map<Integer, Date> parseIntDate(@Nullable String data) {
        return KeyValueFormat.parse(data, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newDateConverter());
    }

    public static Map<Integer, Integer> parseIntInt(@Nullable String data) {
        return KeyValueFormat.parse(data, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newIntegerConverter());
    }

    public static Map<Integer, Date> parseIntDateTime(@Nullable String data) {
        return KeyValueFormat.parse(data, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newDateTimeConverter());
    }

    private static <K, V> String formatEntries(Collection<Map.Entry<K, V>> entries, Converter<K> keyConverter, Converter<V> valueConverter) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<K, V> entry : entries) {
            if (!first) {
                sb.append(PAIR_SEPARATOR);
            }
            sb.append(keyConverter.format(entry.getKey()));
            sb.append(FIELD_SEPARATOR);
            if (entry.getValue() != null) {
                sb.append(valueConverter.format(entry.getValue()));
            }
            first = false;
        }
        return sb.toString();
    }

    public static <K, V> String format(Map<K, V> map, Converter<K> keyConverter, Converter<V> valueConverter) {
        return KeyValueFormat.formatEntries(map.entrySet(), keyConverter, valueConverter);
    }

    public static String format(Map map) {
        return KeyValueFormat.format(map, KeyValueFormat.newToStringConverter(), KeyValueFormat.newToStringConverter());
    }

    public static String formatIntString(Map<Integer, String> map) {
        return KeyValueFormat.format(map, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newStringConverter());
    }

    public static String formatIntDouble(Map<Integer, Double> map) {
        return KeyValueFormat.format(map, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newDoubleConverter());
    }

    public static String formatIntDate(Map<Integer, Date> map) {
        return KeyValueFormat.format(map, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newDateConverter());
    }

    public static String formatIntDateTime(Map<Integer, Date> map) {
        return KeyValueFormat.format(map, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newDateTimeConverter());
    }

    public static String formatStringInt(Map<String, Integer> map) {
        return KeyValueFormat.format(map, KeyValueFormat.newStringConverter(), KeyValueFormat.newIntegerConverter());
    }

    public static class DateConverter
    extends Converter<Date> {
        private SimpleDateFormat dateFormat;

        private DateConverter(String format) {
            this.dateFormat = new SimpleDateFormat(format);
        }

        @Override
        String format(@Nullable Date d) {
            return d == null ? "" : this.dateFormat.format(d);
        }

        @Override
        Date parse(String s) {
            try {
                return StringUtils.isBlank(s) ? null : this.dateFormat.parse(s);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Not a date with format: " + this.dateFormat.toPattern(), e);
            }
        }
    }

    public static final class DoubleConverter
    extends Converter<Double> {
        private static final DoubleConverter INSTANCE = new DoubleConverter();

        private DoubleConverter() {
        }

        @Override
        String format(@Nullable Double d) {
            return d == null ? "" : String.valueOf(d);
        }

        @Override
        Double parse(String s) {
            return StringUtils.isBlank(s) ? null : Double.valueOf(NumberUtils.toDouble(s));
        }
    }

    public static final class PriorityConverter
    extends Converter<RulePriority> {
        private static final PriorityConverter INSTANCE = new PriorityConverter();

        private PriorityConverter() {
        }

        @Override
        String format(@Nullable RulePriority s) {
            return s == null ? "" : s.toString();
        }

        @Override
        RulePriority parse(String s) {
            return StringUtils.isBlank(s) ? null : RulePriority.valueOf(s);
        }
    }

    public static final class IntegerConverter
    extends Converter<Integer> {
        private static final IntegerConverter INSTANCE = new IntegerConverter();

        private IntegerConverter() {
        }

        @Override
        String format(@Nullable Integer s) {
            return s == null ? "" : String.valueOf(s);
        }

        @Override
        Integer parse(String s) {
            return StringUtils.isBlank(s) ? null : Integer.valueOf(NumberUtils.toInt(s));
        }
    }

    public static final class ToStringConverter
    extends Converter<Object> {
        private static final ToStringConverter INSTANCE = new ToStringConverter();

        private ToStringConverter() {
        }

        @Override
        String format(@Nullable Object o) {
            return o == null ? "" : this.escape(o.toString());
        }

        @Override
        String parse(String s) {
            throw new UnsupportedOperationException("Can not parse with ToStringConverter: " + s);
        }
    }

    public static final class StringConverter
    extends Converter<String> {
        private static final StringConverter INSTANCE = new StringConverter();

        private StringConverter() {
        }

        @Override
        String format(@Nullable String s) {
            return s == null ? "" : this.escape(s);
        }

        @Override
        String parse(String s) {
            return s;
        }
    }

    public static abstract class Converter<T> {
        abstract String format(@Nullable T var1);

        @CheckForNull
        abstract T parse(String var1);

        String escape(String s) {
            if (s.contains(KeyValueFormat.FIELD_SEPARATOR) || s.contains(KeyValueFormat.PAIR_SEPARATOR)) {
                return '\"' + s.replace("\"", "\\\"") + '\"';
            }
            return s;
        }
    }

    static class FieldParser {
        private static final char DOUBLE_QUOTE = '\"';
        private final String csv;
        private int position = 0;

        FieldParser(String csv) {
            this.csv = csv;
        }

        @CheckForNull
        String nextKey() {
            return this.next('=');
        }

        @CheckForNull
        String nextVal() {
            return this.next(';');
        }

        @CheckForNull
        private String next(char separator) {
            if (this.position >= this.csv.length()) {
                return null;
            }
            FieldParserContext context = new FieldParserContext();
            context.firstChar = this.csv.charAt(this.position);
            this.checkEscaped(context);
            boolean isEnd = false;
            while (this.position < this.csv.length() && !isEnd) {
                isEnd = this.advance(separator, context);
            }
            return context.result.toString();
        }

        private boolean advance(char separator, FieldParserContext context) {
            boolean end = false;
            char c = this.csv.charAt(this.position);
            if (c == separator && !context.escaped) {
                end = true;
                ++this.position;
            } else if (c == '\\' && context.escaped && this.position < this.csv.length() + 1 && this.csv.charAt(this.position + 1) == '\"') {
                context.previous = (char)34;
                context.result.append(context.previous);
                this.position += 2;
            } else if (c == '\"' && context.escaped && context.previous != '\\') {
                end = true;
                this.position += 2;
            } else {
                context.result.append(c);
                context.previous = c;
                ++this.position;
            }
            return end;
        }

        private void checkEscaped(FieldParserContext context) {
            if (context.firstChar == '\"') {
                context.escaped = true;
                ++this.position;
                context.previous = context.firstChar;
            }
        }
    }

    private static class FieldParserContext {
        private final StringBuilder result = new StringBuilder();
        private boolean escaped = false;
        private char firstChar;
        private char previous = (char)65535;

        private FieldParserContext() {
        }
    }
}

