/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.text.TextUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.json.JSONException;
import org.json.JSONObject;

@Immutable
public final class Sku {
    @Nonnull
    public final Id id;
    @Nonnull
    public final String price;
    @Nonnull
    public final Price detailedPrice;
    @Nonnull
    public final String title;
    @Nonnull
    public final String description;
    @Nonnull
    public final String subscriptionPeriod;
    @Nonnull
    public final String introductoryPrice;
    @Nonnull
    public final Price detailedIntroductoryPrice;
    @Nonnull
    public final String freeTrialPeriod;
    @Nonnull
    public final String introductoryPricePeriod;
    public final int introductoryPriceCycles;
    @Nullable
    private String mDisplayTitle;

    public Sku(@Nonnull String product, @Nonnull String code, @Nonnull String price, @Nonnull Price detailedPrice, @Nonnull String title, @Nonnull String description, @Nonnull String introductoryPrice, @Nonnull Price detailedIntroductoryPrice, @Nonnull String subscriptionPeriod, @Nonnull String freeTrialPeriod, @Nonnull String introductoryPricePeriod, int introductoryPriceCycles) {
        this.introductoryPrice = introductoryPrice;
        this.introductoryPriceCycles = introductoryPriceCycles;
        this.id = new Id(product, code);
        this.price = price;
        this.detailedPrice = detailedPrice;
        this.title = title;
        this.description = description;
        this.detailedIntroductoryPrice = detailedIntroductoryPrice;
        this.subscriptionPeriod = subscriptionPeriod;
        this.freeTrialPeriod = freeTrialPeriod;
        this.introductoryPricePeriod = introductoryPricePeriod;
    }

    Sku(@Nonnull String json, @Nonnull String product) throws JSONException {
        JSONObject object = new JSONObject(json);
        this.id = new Id(product, object.getString("productId"));
        this.price = object.getString("price");
        this.detailedPrice = Price.regularPriceFromJson(object);
        this.title = object.getString("title");
        this.description = object.optString("description");
        this.subscriptionPeriod = object.optString("subscriptionPeriod");
        this.introductoryPrice = object.optString("introductoryPrice");
        this.detailedIntroductoryPrice = Price.introductoryPriceFromJson(object);
        this.freeTrialPeriod = object.optString("freeTrialPeriod");
        this.introductoryPricePeriod = object.optString("introductoryPricePeriod");
        this.introductoryPriceCycles = object.optInt("introductoryPriceCycles");
    }

    @Nonnull
    static Sku fromJson(@Nonnull String json, @Nonnull String product) throws JSONException {
        return new Sku(json, product);
    }

    @Nonnull
    private static String makeDisplayTitle(String title) {
        if (TextUtils.isEmpty((CharSequence)title)) {
            return "";
        }
        char lastChar = title.charAt(title.length() - 1);
        if (lastChar != ')') {
            return title;
        }
        int i = Sku.indexOfAppName(title);
        if (i > 0) {
            return title.substring(0, i).trim();
        }
        return title;
    }

    private static int indexOfAppName(String title) {
        int depth = 0;
        for (int i = title.length() - 1; i >= 0; --i) {
            char c = title.charAt(i);
            if (c == ')') {
                ++depth;
            } else if (c == '(') {
                --depth;
            }
            if (depth != 0) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    public String toJson() throws JSONException {
        return this.toJsonObject().toString();
    }

    @Nonnull
    JSONObject toJsonObject() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("productId", (Object)this.id.code);
        json.put("price", (Object)this.price);
        if (this.detailedPrice.isValid()) {
            json.put("price_amount_micros", this.detailedPrice.amount);
            json.put("price_currency_code", (Object)this.detailedPrice.currency);
        }
        json.put("title", (Object)this.title);
        json.put("description", (Object)this.description);
        if (!TextUtils.isEmpty((CharSequence)this.subscriptionPeriod)) {
            json.put("subscriptionPeriod", (Object)this.subscriptionPeriod);
        }
        if (!TextUtils.isEmpty((CharSequence)this.freeTrialPeriod)) {
            json.put("freeTrialPeriod", (Object)this.freeTrialPeriod);
        }
        if (!TextUtils.isEmpty((CharSequence)this.introductoryPricePeriod)) {
            json.put("introductoryPricePeriod", (Object)this.introductoryPricePeriod);
        }
        if (!TextUtils.isEmpty((CharSequence)this.introductoryPrice)) {
            json.put("introductoryPrice", (Object)this.introductoryPrice);
        }
        if (this.detailedIntroductoryPrice.isValid()) {
            json.put("introductoryPriceAmountMicros", this.detailedIntroductoryPrice.amount);
        }
        if (this.introductoryPriceCycles != 0) {
            json.put("introductoryPriceCycles", this.introductoryPriceCycles);
        }
        return json;
    }

    public String toString() {
        return this.id + "{" + this.getDisplayTitle() + ", " + this.price + "}";
    }

    @Nonnull
    public String getDisplayTitle() {
        if (this.mDisplayTitle == null) {
            this.mDisplayTitle = Sku.makeDisplayTitle(this.title);
        }
        return this.mDisplayTitle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sku that = (Sku)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isInApp() {
        return this.id.isInApp();
    }

    public boolean isSubscription() {
        return this.id.isSubscription();
    }

    public static final class Price {
        @Nonnull
        public static final Price EMPTY = new Price(0L, "");
        public final long amount;
        @Nonnull
        public final String currency;

        public Price(long amount, @Nonnull String currency) {
            this.amount = amount;
            this.currency = currency;
        }

        @Nonnull
        private static Price regularPriceFromJson(@Nonnull JSONObject json) throws JSONException {
            long amount = json.optLong("price_amount_micros");
            String currency = json.optString("price_currency_code");
            if (amount == 0L || TextUtils.isEmpty((CharSequence)currency)) {
                return EMPTY;
            }
            return new Price(amount, currency);
        }

        @Nonnull
        protected static Price introductoryPriceFromJson(@Nonnull JSONObject json) throws JSONException {
            long amount = json.optLong("introductoryPriceAmountMicros");
            String currency = json.optString("price_currency_code");
            if (amount == 0L || TextUtils.isEmpty((CharSequence)currency)) {
                return EMPTY;
            }
            return new Price(amount, currency);
        }

        public boolean isValid() {
            return this.amount > 0L && !TextUtils.isEmpty((CharSequence)this.currency);
        }

        public String toString() {
            return this.currency + this.amount;
        }
    }

    public static final class Id {
        public final String product;
        public final String code;

        public Id(String product, String code) {
            this.product = product;
            this.code = code;
        }

        public boolean isInApp() {
            return this.product.equals("inapp");
        }

        public boolean isSubscription() {
            return this.product.equals("subs");
        }

        public String toString() {
            return this.product + "/" + this.code;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id that = (Id)o;
            if (!this.product.equals(that.product)) {
                return false;
            }
            return this.code.equals(that.code);
        }

        public int hashCode() {
            int result = this.product.hashCode();
            result = 31 * result + this.code.hashCode();
            return result;
        }
    }
}

