/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.os.Handler;
import android.os.Looper;
import javax.annotation.Nonnull;
import org.solovyev.android.checkout.CancellableExecutor;
import org.solovyev.android.checkout.Check;

final class MainThread
implements CancellableExecutor {
    @Nonnull
    private final Handler mHandler;

    MainThread(@Nonnull Handler handler) {
        Check.isTrue(handler.getLooper() == Looper.getMainLooper(), "Should be main application thread handler");
        this.mHandler = handler;
    }

    static boolean isMainThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }

    @Override
    public void execute(@Nonnull Runnable runnable) {
        if (MainThread.isMainThread()) {
            runnable.run();
        } else {
            this.mHandler.post(runnable);
        }
    }

    @Override
    public void cancel(@Nonnull Runnable runnable) {
        this.mHandler.removeCallbacks(runnable);
    }
}

