/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.wizard;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import android.widget.Button;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.wizard.FinishWizardConfirmationDialog;
import org.solovyev.android.wizard.R;
import org.solovyev.android.wizard.Wizard;
import org.solovyev.android.wizard.WizardFlow;
import org.solovyev.android.wizard.WizardStep;
import org.solovyev.android.wizard.Wizards;
import org.solovyev.android.wizard.WizardsAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardUi<A extends FragmentActivity> {
    private static final String FLOW = "flow";
    private static final String STEP = "step";
    private WizardStep step;
    private Wizard wizard;
    @Nullable
    private View prevButton;
    @Nonnull
    private Button nextButton;
    @Nonnull
    private final A activity;
    @Nonnull
    private final WizardsAware wizardsAware;
    private final int layoutResId;

    public WizardUi(@Nonnull A activity, @Nonnull WizardsAware wizardsAware, int layoutResId) {
        if (activity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.<init> must not be null");
        }
        if (wizardsAware == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.<init> must not be null");
        }
        this.activity = activity;
        this.wizardsAware = wizardsAware;
        this.layoutResId = layoutResId;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        this.activity.setContentView(this.layoutResId);
        this.prevButton = this.activity.findViewById(R.id.acl_wizard_prev_button);
        this.nextButton = (Button)this.activity.findViewById(R.id.acl_wizard_next_button);
        String wizardName = this.activity.getIntent().getStringExtra(FLOW);
        String stepName = this.activity.getIntent().getStringExtra(STEP);
        if (savedInstanceState != null) {
            wizardName = savedInstanceState.getString(FLOW);
            stepName = savedInstanceState.getString(STEP);
        }
        this.wizard = this.wizardsAware.getWizards().getWizard(wizardName);
        WizardStep step = null;
        if (stepName != null) {
            step = this.wizard.getFlow().getStepByName(stepName);
        }
        if (step == null) {
            step = this.wizard.getFlow().getFirstStep();
        }
        this.setStep(step);
    }

    public void setStep(@Nonnull WizardStep step) {
        if (step == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.setStep must not be null");
        }
        if (this.step == null || !this.step.equals(step)) {
            this.hideFragment();
            this.step = step;
            this.showFragment();
            this.initTitle();
            this.initNextButton();
            this.initPrevButton();
        }
    }

    private void initTitle() {
        this.activity.setTitle(this.step.getTitleResId());
    }

    private void initPrevButton() {
        if (this.prevButton != null) {
            final WizardStep prevStep = this.wizard.getFlow().getPrevStep(this.step);
            if (prevStep == null) {
                this.prevButton.setVisibility(8);
                this.prevButton.setOnClickListener(null);
            } else {
                this.prevButton.setVisibility(0);
                this.prevButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (WizardUi.this.tryGoPrev()) {
                            WizardUi.this.setStep(prevStep);
                        }
                    }
                });
            }
        }
    }

    private void initNextButton() {
        final WizardStep nextStep = this.wizard.getFlow().getNextStep(this.step);
        if (nextStep == null) {
            this.nextButton.setText(R.string.acl_wizard_finish);
            this.nextButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (WizardUi.this.tryGoNext()) {
                        WizardUi.this.finishWizard();
                    }
                }
            });
        } else {
            this.nextButton.setText(this.step.getNextButtonTitleResId());
            this.nextButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (WizardUi.this.tryGoNext()) {
                        WizardUi.this.setStep(nextStep);
                    }
                }
            });
        }
    }

    public void finishWizardAbruptly() {
        this.finishWizard(true);
    }

    public void finishWizard() {
        this.finishWizard(false);
    }

    void finishWizard(boolean forceFinish) {
        if (this.wizard != null && this.step != null) {
            this.wizard.saveFinished(this.step, forceFinish);
        }
        this.activity.finish();
    }

    private boolean tryGoPrev() {
        if (this.step == null) {
            return true;
        }
        Fragment fragment = this.getFragmentManager().findFragmentByTag(this.step.getFragmentTag());
        return fragment == null || this.step.onPrev(fragment);
    }

    @Nonnull
    private FragmentManager getFragmentManager() {
        FragmentManager fragmentManager = this.activity.getSupportFragmentManager();
        if (fragmentManager == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/wizard/WizardUi.getFragmentManager must not return null");
        }
        return fragmentManager;
    }

    private boolean tryGoNext() {
        if (this.step == null) {
            return true;
        }
        Fragment fragment = this.getFragmentManager().findFragmentByTag(this.step.getFragmentTag());
        return fragment == null || this.step.onNext(fragment);
    }

    @Nonnull
    private Fragment showFragment() {
        FragmentManager fm = this.getFragmentManager();
        FragmentTransaction ft = fm.beginTransaction();
        Fragment newFragment = fm.findFragmentByTag(this.step.getFragmentTag());
        if (newFragment == null) {
            newFragment = Fragment.instantiate(this.activity, (String)this.step.getFragmentClass().getName(), (Bundle)this.step.getFragmentArgs());
            ft.add(R.id.acl_wizard_content, newFragment, this.step.getFragmentTag());
        }
        ft.commit();
        fm.executePendingTransactions();
        Fragment fragment = newFragment;
        if (fragment == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/wizard/WizardUi.showFragment must not return null");
        }
        return fragment;
    }

    private void hideFragment() {
        FragmentManager fm = this.getFragmentManager();
        FragmentTransaction ft = fm.beginTransaction();
        if (this.step != null) {
            this.hideFragmentByTag(fm, ft, this.step.getFragmentTag());
        }
        ft.commit();
        fm.executePendingTransactions();
    }

    private void hideFragmentByTag(@Nonnull FragmentManager fm, @Nonnull FragmentTransaction ft, @Nonnull String fragmentTag) {
        if (fm == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.hideFragmentByTag must not be null");
        }
        if (ft == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.hideFragmentByTag must not be null");
        }
        if (fragmentTag == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.hideFragmentByTag must not be null");
        }
        Fragment oldFragment = fm.findFragmentByTag(fragmentTag);
        if (oldFragment != null) {
            ft.remove(oldFragment);
        }
    }

    public void onSaveInstanceState(@Nonnull Bundle out) {
        if (out == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.onSaveInstanceState must not be null");
        }
        out.putString(FLOW, this.wizard.getName());
        out.putString(STEP, this.step.getName());
    }

    public void onPause() {
        if (this.wizard != null && this.step != null) {
            this.wizard.saveLastStep(this.step);
        }
    }

    public void onBackPressed() {
        FinishWizardConfirmationDialog.show(this.activity);
    }

    public WizardStep getStep() {
        return this.step;
    }

    public WizardFlow getFlow() {
        return this.wizard.getFlow();
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    @Nullable
    public View getPrevButton() {
        return this.prevButton;
    }

    public View getNextButton() {
        return this.nextButton;
    }

    public static void startWizard(@Nonnull Wizards wizards, @Nonnull Context context) {
        if (wizards == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.startWizard must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.startWizard must not be null");
        }
        context.startActivity(WizardUi.createLaunchIntent(wizards, null, context));
    }

    public static void startWizard(@Nonnull Wizards wizards, @Nullable String name, @Nonnull Context context) {
        if (wizards == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.startWizard must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.startWizard must not be null");
        }
        context.startActivity(WizardUi.createLaunchIntent(wizards, name, context));
    }

    public static void continueWizard(@Nonnull Wizards wizards, @Nonnull String name, @Nonnull Context context) {
        if (wizards == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.continueWizard must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.continueWizard must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.continueWizard must not be null");
        }
        Intent intent = WizardUi.createLaunchIntent(wizards, name, context);
        Wizard wizard = wizards.getWizard(name);
        String step = wizard.getLastSavedStepName();
        WizardUi.tryPutStep(intent, step);
        context.startActivity(intent);
    }

    public static void tryPutStep(@Nonnull Intent intent, @Nullable WizardStep step) {
        if (intent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.tryPutStep must not be null");
        }
        WizardUi.tryPutStep(intent, step != null ? step.getName() : null);
    }

    private static void tryPutStep(@Nonnull Intent intent, @Nullable String step) {
        if (intent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.tryPutStep must not be null");
        }
        if (step != null) {
            intent.putExtra(STEP, step);
        }
    }

    @Nonnull
    private static Intent createLaunchIntent(@Nonnull Wizards wizards, @Nullable String name, @Nonnull Context context) {
        if (wizards == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.createLaunchIntent must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/wizard/WizardUi.createLaunchIntent must not be null");
        }
        Intent intent = new Intent(context, wizards.getActivityClassName());
        intent.putExtra(FLOW, name);
        intent.setFlags(0x20000000);
        Intent intent2 = intent;
        if (intent2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/wizard/WizardUi.createLaunchIntent must not return null");
        }
        return intent2;
    }
}

