/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.wizard;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.wizard.WizardFlow;
import org.solovyev.android.wizard.WizardStep;
import org.solovyev.common.JPredicate;
import org.solovyev.common.collections.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListWizardFlow
implements WizardFlow {
    @Nonnull
    private final List<WizardStep> steps;

    public ListWizardFlow(@Nonnull List<WizardStep> steps) {
        if (steps == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/ListWizardFlow.<init> must not be null");
        }
        this.steps = steps;
    }

    @Override
    @Nullable
    public WizardStep getStepByName(final @Nonnull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/ListWizardFlow.getStepByName must not be null");
        }
        return (WizardStep)Collections.find(this.steps, (JPredicate)new JPredicate<WizardStep>(){

            public boolean apply(@Nullable WizardStep step) {
                assert (step != null);
                return step.getName().equals(name);
            }
        });
    }

    @Override
    @Nullable
    public WizardStep getNextStep(@Nonnull WizardStep step) {
        if (step == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/ListWizardFlow.getNextStep must not be null");
        }
        int i = this.steps.indexOf(step);
        if (i >= 0 && i + 1 < this.steps.size()) {
            return this.steps.get(i + 1);
        }
        return null;
    }

    @Override
    @Nullable
    public WizardStep getPrevStep(@Nonnull WizardStep step) {
        if (step == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/ListWizardFlow.getPrevStep must not be null");
        }
        int i = this.steps.indexOf(step);
        if (i >= 1) {
            return this.steps.get(i - 1);
        }
        return null;
    }

    @Override
    @Nonnull
    public WizardStep getFirstStep() {
        WizardStep wizardStep = this.steps.get(0);
        if (wizardStep == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/wizard/ListWizardFlow.getFirstStep must not return null");
        }
        return wizardStep;
    }
}

