/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view.sidebar;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.view.sidebar.OnSlideListener;
import org.solovyev.android.view.sidebar.SideBarAttributes;
import org.solovyev.android.view.sidebar.SideBarSlider;
import org.solovyev.android.view.sidebar.SideBarSlidingViewPosition;

public final class SideBarLayout
extends FrameLayout
implements OnSlideListener {
    private static final int DRAW_FRAMES_SKIP_COUNT = 5;
    private static final int MIN_Z_DIFF = 50;
    private Bitmap cachedBitmap;
    private Canvas cachedCanvas;
    private Paint cachedPaint;
    @Nonnull
    private final AtomicInteger drawCounter = new AtomicInteger(0);
    private View mainView;
    private View slidingView;
    @Nonnull
    private SideBarAttributes attributes;
    @Nonnull
    private SlidingViewState slidingViewState = SlidingViewState.Closed;
    @Nonnull
    private SideBarSlider slider;
    private boolean alwaysOpened = false;
    @Nullable
    private OnSlideListener listener;
    private int mHistoricalZ = 0;

    public SideBarLayout(Context context, int mainViewId, int slidingViewId) {
        super(context);
        this.attributes = SideBarAttributes.newAttributes(mainViewId, slidingViewId, 0, SideBarSlidingViewPosition.left);
        this.init(context, null);
    }

    public SideBarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public SideBarLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(@Nonnull Context context, @Nullable AttributeSet attrs) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/sidebar/SideBarLayout.init must not be null");
        }
        if (attrs != null) {
            this.attributes = SideBarAttributes.newAttributes(context, attrs);
        }
        this.slider = new SideBarSlider((View)this, this.attributes, this);
        this.cachedPaint = new Paint(7);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View slidingView = this.getSlidingView();
        if (this.attributes.isSlideMainView()) {
            int slidingViewLedge = this.attributes.getSlidingViewLedge();
            if (this.alwaysOpened || slidingViewLedge > 0) {
                View mainView = this.getMainView();
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)mainView.getLayoutParams();
                if (this.alwaysOpened) {
                    this.measureChild(slidingView, widthMeasureSpec, heightMeasureSpec);
                    switch (this.attributes.getSlidingViewPosition()) {
                        case left: {
                            lp.leftMargin = slidingView.getMeasuredWidth();
                            break;
                        }
                        case top: {
                            lp.topMargin = slidingView.getMeasuredWidth();
                            break;
                        }
                        case right: {
                            lp.rightMargin = slidingView.getMeasuredWidth();
                            break;
                        }
                        case bottom: {
                            lp.bottomMargin = slidingView.getMeasuredWidth();
                        }
                    }
                } else {
                    switch (this.attributes.getSlidingViewPosition()) {
                        case left: {
                            this.measureChild(slidingView, slidingViewLedge, heightMeasureSpec);
                            lp.leftMargin = slidingViewLedge;
                            break;
                        }
                        case top: {
                            this.measureChild(slidingView, widthMeasureSpec, slidingViewLedge);
                            lp.topMargin = slidingViewLedge;
                            break;
                        }
                        case right: {
                            this.measureChild(slidingView, slidingViewLedge, heightMeasureSpec);
                            lp.rightMargin = slidingViewLedge;
                            break;
                        }
                        case bottom: {
                            this.measureChild(slidingView, widthMeasureSpec, slidingViewLedge);
                            lp.bottomMargin = slidingViewLedge;
                        }
                    }
                }
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int offset;
        int slidingViewHeight;
        int slidingViewWidth;
        View mainView;
        View slidingView;
        int width;
        int height;
        block21: {
            block20: {
                height = bottom - top;
                width = right - left;
                slidingView = this.getSlidingView();
                mainView = this.getMainView();
                slidingViewWidth = slidingView.getMeasuredWidth();
                slidingViewHeight = slidingView.getMeasuredHeight();
                if (!this.alwaysOpened && this.slidingViewState != SlidingViewState.Opened) break block20;
                switch (this.attributes.getSlidingViewPosition()) {
                    case left: 
                    case right: {
                        offset = slidingViewWidth;
                        break block21;
                    }
                    case top: 
                    case bottom: {
                        offset = slidingViewHeight;
                        break block21;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            offset = this.slidingViewState == SlidingViewState.Closed ? this.attributes.getSlidingViewLedge() : this.slider.getOffset();
        }
        block4 : switch (this.attributes.getSlidingViewStyle()) {
            case hover: {
                mainView.layout(0, 0, width, height);
                break;
            }
            case push: {
                switch (this.attributes.getSlidingViewPosition()) {
                    case left: {
                        mainView.layout(offset, 0, width + offset, height);
                        break block4;
                    }
                    case top: {
                        mainView.layout(0, offset, width, height + offset);
                        break block4;
                    }
                    case right: {
                        mainView.layout(-offset, 0, width - offset, height);
                        break block4;
                    }
                    case bottom: {
                        mainView.layout(0, -offset, width, height - offset);
                    }
                }
            }
        }
        switch (this.attributes.getSlidingViewPosition()) {
            case left: {
                slidingView.layout(-slidingViewWidth + offset, 0, offset, height);
                break;
            }
            case top: {
                slidingView.layout(0, offset - slidingViewHeight, width, offset);
                break;
            }
            case right: {
                slidingView.layout(width - offset, 0, width - offset + slidingViewWidth, height);
                break;
            }
            case bottom: {
                slidingView.layout(0, height - offset, width, height - offset + slidingViewHeight);
            }
        }
        this.invalidate();
    }

    protected void dispatchDraw(Canvas canvas) {
        try {
            if (this.slidingViewState.isTransition()) {
                if (this.drawCounter.getAndIncrement() > 5) {
                    this.updateCachedCanvas();
                    this.drawCounter.set(0);
                }
                canvas.save();
                block1 : switch (this.attributes.getSlidingViewStyle()) {
                    case push: {
                        switch (this.attributes.getSlidingViewPosition()) {
                            case left: {
                                canvas.translate((float)this.slider.getOffset(), 0.0f);
                                break block1;
                            }
                            case top: {
                                canvas.translate(0.0f, (float)this.slider.getOffset());
                                break block1;
                            }
                            case right: {
                                canvas.translate((float)(-this.slider.getOffset()), 0.0f);
                                break block1;
                            }
                            case bottom: {
                                canvas.translate(0.0f, (float)(-this.slider.getOffset()));
                            }
                        }
                    }
                }
                canvas.drawBitmap(this.cachedBitmap, 0.0f, 0.0f, this.cachedPaint);
                canvas.restore();
                View slidingView = this.getSlidingView();
                int scrollX = slidingView.getScrollX();
                int scrollY = slidingView.getScrollY();
                canvas.save();
                int width = canvas.getWidth();
                int height = canvas.getHeight();
                switch (this.attributes.getSlidingViewPosition()) {
                    case left: {
                        canvas.clipRect(0.0f, 0.0f, (float)this.slider.getOffsetOnScreen(), (float)height, Region.Op.REPLACE);
                        canvas.translate((float)(-scrollX - (slidingView.getMeasuredWidth() - this.slider.getOffset())), (float)(-scrollY));
                        break;
                    }
                    case top: {
                        canvas.clipRect(0.0f, 0.0f, (float)width, (float)this.slider.getOffsetOnScreen(), Region.Op.REPLACE);
                        canvas.translate((float)(-scrollX), (float)(-scrollY - slidingView.getMeasuredHeight() + this.slider.getOffsetOnScreen()));
                        break;
                    }
                    case right: {
                        canvas.clipRect((float)this.slider.getOffsetOnScreen(), 0.0f, (float)width, (float)height, Region.Op.REPLACE);
                        canvas.translate((float)(-scrollX + this.slider.getOffsetOnScreen()), (float)(-scrollY));
                        break;
                    }
                    case bottom: {
                        canvas.clipRect(0.0f, (float)this.slider.getOffsetOnScreen(), (float)width, (float)height, Region.Op.REPLACE);
                        canvas.translate((float)(-scrollX), (float)(-scrollY + this.slider.getOffsetOnScreen()));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                slidingView.draw(canvas);
                canvas.restore();
            } else {
                if (!this.alwaysOpened && !this.attributes.isSlidingViewLedgeExists() && this.slidingViewState == SlidingViewState.Closed) {
                    this.getSlidingView().setVisibility(8);
                }
                super.dispatchDraw(canvas);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void updateCachedCanvas() {
        View mainView = this.getMainView();
        this.cachedCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        this.cachedCanvas.translate((float)(-mainView.getScrollX()), (float)(-mainView.getScrollY()));
        mainView.draw(this.cachedCanvas);
    }

    protected Parcelable onSaveInstanceState() {
        boolean opened = this.slidingViewState == SlidingViewState.Opened ? true : (this.slidingViewState.isTransition() ? this.slider.isOpening() : false);
        return new ViewState(super.onSaveInstanceState(), opened);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof ViewState) {
            ViewState viewState = (ViewState)state;
            super.onRestoreInstanceState(viewState.getSuperState());
            if (viewState.mOpened) {
                this.openImmediately();
            } else {
                this.closeImmediately();
            }
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    @Nonnull
    private View getSlidingView() {
        if (this.slidingView == null) {
            this.slidingView = this.findViewById(this.attributes.getSlidingViewId());
        }
        View view = this.slidingView;
        if (view == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/sidebar/SideBarLayout.getSlidingView must not return null");
        }
        return view;
    }

    @Nonnull
    private View getMainView() {
        if (this.mainView == null) {
            this.mainView = this.findViewById(this.attributes.getMainViewId());
        }
        View view = this.mainView;
        if (view == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/sidebar/SideBarLayout.getMainView must not return null");
        }
        return view;
    }

    public void setAlwaysOpened(boolean opened) {
        this.alwaysOpened = opened;
        this.requestLayout();
    }

    public void setOnSlideListener(OnSlideListener lis) {
        this.listener = lis;
    }

    public boolean isOpened() {
        return this.slidingViewState == SlidingViewState.Opened;
    }

    public void toggle(boolean immediately) {
        if (immediately) {
            this.toggleImmediately();
        } else {
            this.toggle();
        }
    }

    public void toggle() {
        if (this.isOpened()) {
            this.close();
        } else {
            this.open();
        }
    }

    public void toggleImmediately() {
        if (this.isOpened()) {
            this.closeImmediately();
        } else {
            this.openImmediately();
        }
    }

    public boolean open() {
        if (this.isOpened() || this.alwaysOpened || this.slidingViewState.isTransition()) {
            return false;
        }
        this.initSlideMode();
        this.startAnimation(this.slider.newOpenAnimation());
        this.invalidate();
        return true;
    }

    public boolean openImmediately() {
        if (this.isOpened() || this.alwaysOpened || this.slidingViewState.isTransition()) {
            return false;
        }
        this.getSlidingView().setVisibility(0);
        this.slidingViewState = SlidingViewState.Opened;
        this.requestLayout();
        if (this.listener != null) {
            this.listener.onSlideCompleted(true);
        }
        return true;
    }

    public boolean close() {
        if (!this.isOpened() || this.alwaysOpened || this.slidingViewState.isTransition()) {
            return false;
        }
        this.initSlideMode();
        this.startAnimation(this.slider.newCloseAnimation());
        this.invalidate();
        return true;
    }

    public boolean closeImmediately() {
        if (!this.isOpened() || this.alwaysOpened || this.slidingViewState.isTransition()) {
            return false;
        }
        if (!this.attributes.isSlidingViewLedgeExists()) {
            this.getSlidingView().setVisibility(8);
        }
        this.slidingViewState = SlidingViewState.Closed;
        this.requestLayout();
        if (this.listener != null) {
            this.listener.onSlideCompleted(false);
        }
        return true;
    }

    public boolean dispatchTouchEvent(MotionEvent e) {
        if (this.alwaysOpened) {
            return super.dispatchTouchEvent(e);
        }
        if (!this.isEnabled() && this.slidingViewState == SlidingViewState.Closed) {
            return super.dispatchTouchEvent(e);
        }
        if (this.slidingViewState != SlidingViewState.Opened) {
            this.onTouchEvent(e);
            if (this.slidingViewState.isEndState()) {
                super.dispatchTouchEvent(e);
            } else {
                MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)e);
                cancelEvent.setAction(3);
                super.dispatchTouchEvent(cancelEvent);
            }
            return true;
        }
        View slidingView = this.getSlidingView();
        View mainView = this.getMainView();
        Rect slidingRect = new Rect();
        slidingView.getHitRect(slidingRect);
        if (!slidingRect.contains((int)e.getX(), (int)e.getY())) {
            e.offsetLocation((float)(-mainView.getLeft()), (float)(-mainView.getTop()));
            mainView.dispatchTouchEvent(e);
            e.offsetLocation((float)mainView.getLeft(), (float)mainView.getTop());
            this.onTouchEvent(e);
            return true;
        }
        this.onTouchEvent(e);
        e.offsetLocation((float)(-slidingView.getLeft()), (float)(-slidingView.getTop()));
        slidingView.dispatchTouchEvent(e);
        return true;
    }

    private boolean handleTouchEvent(@Nonnull MotionEvent e) {
        float z;
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/sidebar/SideBarLayout.handleTouchEvent must not be null");
        }
        if (!this.isEnabled()) {
            return false;
        }
        switch (this.attributes.getSlidingViewPosition()) {
            case left: 
            case right: {
                z = e.getX();
                break;
            }
            case top: 
            case bottom: {
                z = e.getY();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        switch (e.getAction()) {
            case 0: {
                this.mHistoricalZ = (int)z;
                return true;
            }
            case 2: {
                return this.handleTouchMove(z);
            }
            case 1: {
                if (this.slidingViewState == SlidingViewState.InTransition) {
                    this.slider.finishSlide();
                }
                return false;
            }
        }
        return this.slidingViewState.isTransition();
    }

    private boolean handleTouchMove(float z) {
        boolean closingAllowed;
        boolean openingAllowed;
        float diff = z - (float)this.mHistoricalZ;
        float prevHistoricalZ = this.mHistoricalZ;
        this.mHistoricalZ = (int)z;
        if (this.slidingViewState.isTransition()) {
            if (this.slidingViewState == SlidingViewState.InTransition) {
                this.slider.addOffsetDelta((int)diff);
            }
            return true;
        }
        switch (this.attributes.getSlidingViewPosition()) {
            case left: 
            case top: {
                openingAllowed = diff > 50.0f && this.slidingViewState == SlidingViewState.Closed;
                closingAllowed = diff < -50.0f && this.slidingViewState == SlidingViewState.Opened;
                break;
            }
            case right: 
            case bottom: {
                openingAllowed = diff < -50.0f && this.slidingViewState == SlidingViewState.Closed;
                closingAllowed = diff > 50.0f && this.slidingViewState == SlidingViewState.Opened;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if ((openingAllowed || closingAllowed) && this.slider.canStartSlide(prevHistoricalZ)) {
            this.initSlideMode();
            this.slider.addOffsetDelta((int)diff);
        }
        return false;
    }

    public void startAnimation(Animation animation) {
        this.slidingViewState = SlidingViewState.InAnimation;
        super.startAnimation(animation);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        boolean handled = this.handleTouchEvent(ev);
        this.invalidate();
        return handled;
    }

    private void initSlideMode() {
        int openedOffset;
        View mainView = this.getMainView();
        int width = this.getWidth();
        int height = this.getHeight();
        switch (this.attributes.getSlidingViewPosition()) {
            case left: 
            case right: {
                openedOffset = this.getSlidingView().getMeasuredWidth();
                break;
            }
            case top: 
            case bottom: {
                openedOffset = this.getSlidingView().getMeasuredHeight();
                break;
            }
            default: {
                throw new UnsupportedOperationException("");
            }
        }
        this.slider.init(this.attributes.getSlidingViewLedge(), openedOffset, this.slidingViewState == SlidingViewState.Closed);
        if (this.cachedBitmap == null || this.cachedBitmap.isRecycled() || this.cachedBitmap.getWidth() != width) {
            this.cachedBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.cachedCanvas = new Canvas(this.cachedBitmap);
        }
        mainView.setVisibility(0);
        this.updateCachedCanvas();
        this.slidingViewState = SlidingViewState.InTransition;
        this.getSlidingView().setVisibility(0);
    }

    public void onSlideCompleted(final boolean opened) {
        this.requestLayout();
        this.post(new Runnable(){

            public void run() {
                if (opened) {
                    SideBarLayout.this.slidingViewState = SlidingViewState.Opened;
                    if (!SideBarLayout.this.attributes.isSlidingViewLedgeExists()) {
                        SideBarLayout.this.getSlidingView().setVisibility(0);
                    }
                } else {
                    SideBarLayout.this.slidingViewState = SlidingViewState.Closed;
                    if (!SideBarLayout.this.attributes.isSlidingViewLedgeExists()) {
                        SideBarLayout.this.getSlidingView().setVisibility(8);
                    }
                }
            }
        });
        if (this.listener != null) {
            this.listener.onSlideCompleted(opened);
        }
    }

    public static class ViewState
    extends View.BaseSavedState {
        @Nonnull
        public static final Parcelable.Creator<ViewState> CREATOR = new Parcelable.Creator<ViewState>(){

            public ViewState createFromParcel(Parcel in) {
                return new ViewState(in);
            }

            public ViewState[] newArray(int size) {
                return new ViewState[size];
            }
        };
        private final boolean mOpened;

        public ViewState(Parcel in) {
            super(in);
            this.mOpened = in.readInt() == 1;
        }

        public ViewState(Parcelable state, boolean opened) {
            super(state);
            this.mOpened = opened;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.mOpened ? 1 : 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SlidingViewState {
        Closed(true),
        InTransition(false),
        InAnimation(false),
        Opened(true);

        private final boolean mEndState;

        private SlidingViewState(boolean endState) {
            this.mEndState = endState;
        }

        public boolean isEndState() {
            return this.mEndState;
        }

        public boolean isTransition() {
            return !this.isEndState();
        }
    }
}

