/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view.scroll;

import android.os.Bundle;
import android.widget.ScrollView;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class ScrollViewState
implements Serializable {
    @Nonnull
    private static final String SCROLL_VIEW_STATE = "scroll_view_state";
    private int scrollX;
    private int scrollY;

    public ScrollViewState() {
        this.scrollX = 0;
        this.scrollY = 0;
    }

    public ScrollViewState(@Nonnull ScrollView scrollView) {
        if (scrollView == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/scroll/ScrollViewState.<init> must not be null");
        }
        this.scrollX = 0;
        this.scrollY = 0;
        this.scrollX = scrollView.getScrollX();
        this.scrollY = scrollView.getScrollY();
    }

    public void restoreState(final @Nonnull ScrollView scrollView) {
        if (scrollView == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/scroll/ScrollViewState.restoreState must not be null");
        }
        scrollView.post(new Runnable(){

            public void run() {
                scrollView.scrollTo(ScrollViewState.this.scrollX, ScrollViewState.this.scrollY);
            }
        });
    }

    public static void saveState(@Nonnull Bundle out, @Nonnull ScrollView scrollView) {
        if (out == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/scroll/ScrollViewState.saveState must not be null");
        }
        if (scrollView == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/scroll/ScrollViewState.saveState must not be null");
        }
        out.putSerializable(SCROLL_VIEW_STATE, (Serializable)new ScrollViewState(scrollView));
    }

    public static void restoreState(@Nonnull Bundle in, @Nonnull ScrollView scrollView) {
        if (in == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/scroll/ScrollViewState.restoreState must not be null");
        }
        if (scrollView == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/scroll/ScrollViewState.restoreState must not be null");
        }
        Serializable o = in.getSerializable(SCROLL_VIEW_STATE);
        if (o instanceof ScrollViewState) {
            ((ScrollViewState)o).restoreState(scrollView);
        }
    }
}

