/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view.drag;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.view.AndroidViewUtils;
import org.solovyev.android.view.ButtonDef;
import org.solovyev.android.view.drag.DragButtonDef;
import org.solovyev.android.view.drag.DragEvent;
import org.solovyev.android.view.drag.OnDragListener;
import org.solovyev.common.math.Point2d;
import org.solovyev.common.text.Strings;

public class DragButton
extends Button {
    @Nullable
    private Point2d startPoint;
    @Nullable
    private OnDragListener onDragListener;
    @Nonnull
    private OnTouchListenerImpl onTouchListener;
    private boolean showText;
    @Nonnull
    private final Handler uiHandler;
    @Nullable
    private CharSequence textBackup;

    public DragButton(@Nonnull Context context, @Nonnull AttributeSet attrs) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DragButton.<init> must not be null");
        }
        if (attrs == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/DragButton.<init> must not be null");
        }
        super(context, attrs);
        this.startPoint = null;
        this.showText = true;
        this.uiHandler = new Handler();
        this.setOnTouchListener(new OnTouchListenerImpl());
    }

    public DragButton(@Nonnull Context context, @Nonnull DragButtonDef dragButtonDef) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DragButton.<init> must not be null");
        }
        if (dragButtonDef == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/DragButton.<init> must not be null");
        }
        super(context);
        this.startPoint = null;
        this.showText = true;
        this.uiHandler = new Handler();
        this.setOnTouchListener(new OnTouchListenerImpl());
        this.setText(dragButtonDef.getText());
    }

    public void setOnDragListener(@Nullable OnDragListener onDragListener) {
        this.onDragListener = onDragListener;
    }

    @Nullable
    public OnDragListener getOnDragListener() {
        return this.onDragListener;
    }

    public void applyDef(@Nonnull DragButtonDef buttonDef) {
        if (buttonDef == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DragButton.applyDef must not be null");
        }
        AndroidViewUtils.applyButtonDef(this, (ButtonDef)buttonDef);
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        if (l instanceof OnTouchListenerImpl) {
            this.onTouchListener = (OnTouchListenerImpl)l;
            super.setOnTouchListener(l);
        } else {
            this.onTouchListener.nestedOnTouchListener = l;
        }
    }

    protected void onDraw(Canvas canvas) {
        CharSequence text = this.getText();
        if (!Strings.isEmpty((CharSequence)text)) {
            super.onDraw(canvas);
        } else if (!AndroidViewUtils.drawDrawables(canvas, (TextView)this)) {
            super.onDraw(canvas);
        }
    }

    public boolean isShowText() {
        return this.showText;
    }

    public void setShowText(boolean showText) {
        if (this.showText != showText) {
            if (showText) {
                this.setText(this.textBackup);
                this.textBackup = null;
            } else {
                this.textBackup = this.getText();
                this.setText(null);
            }
            this.showText = showText;
        }
    }

    private final class OnTouchListenerImpl
    implements View.OnTouchListener {
        @Nullable
        private View.OnTouchListener nestedOnTouchListener;

        private OnTouchListenerImpl() {
        }

        public boolean onTouch(@Nonnull View v, @Nonnull MotionEvent event) {
            if (v == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DragButton$OnTouchListenerImpl.onTouch must not be null");
            }
            if (event == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/DragButton$OnTouchListenerImpl.onTouch must not be null");
            }
            boolean consumed = false;
            Point2d localStartPoint = DragButton.this.startPoint;
            OnDragListener localOnDragListener = DragButton.this.onDragListener;
            if (localOnDragListener != null) {
                Log.d((String)String.valueOf(DragButton.this.getId()), (String)("onTouch() for: " + DragButton.this.getId() + " . Motion event: " + event));
                switch (event.getAction()) {
                    case 0: {
                        DragButton.this.startPoint = new Point2d(event.getX(), event.getY());
                        break;
                    }
                    case 1: {
                        if (localStartPoint != null && (consumed = localOnDragListener.onDrag(DragButton.this, new DragEvent(localStartPoint, event))) && localOnDragListener.isSuppressOnClickEvent()) {
                            v.setPressed(false);
                        }
                        DragButton.this.startPoint = null;
                    }
                }
            }
            if (this.nestedOnTouchListener != null && !consumed) {
                return this.nestedOnTouchListener.onTouch(v, event);
            }
            return consumed;
        }
    }
}

