/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import android.content.SharedPreferences;
import android.os.Vibrator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.prefs.BooleanPreference;
import org.solovyev.android.prefs.NumberToStringPreference;
import org.solovyev.android.prefs.Preference;

public class VibratorContainer
implements SharedPreferences.OnSharedPreferenceChangeListener {
    private final float vibrationTimeScale;
    @Nullable
    private final Vibrator vibrator;
    private long time;

    public VibratorContainer(@Nullable Vibrator vibrator, @Nonnull SharedPreferences preferences, float vibrationTimeScale) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/VibratorContainer.<init> must not be null");
        }
        this.time = 0L;
        this.vibrator = vibrator;
        this.vibrationTimeScale = vibrationTimeScale;
        preferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        this.onSharedPreferenceChanged(preferences, null);
    }

    public void vibrate() {
        if (this.time > 0L && this.vibrator != null) {
            this.vibrator.vibrate(this.time);
        }
    }

    public void onSharedPreferenceChanged(SharedPreferences preferences, @Nullable String key) {
        this.time = Preferences.hapticFeedbackEnabled.getPreference(preferences) != false ? this.getScaledValue(Preferences.hapticFeedbackDuration.getPreference(preferences)) : 0L;
    }

    private long getScaledValue(long vibrationTime) {
        return (long)((float)vibrationTime * this.vibrationTimeScale);
    }

    public static class Preferences {
        public static final Preference<Boolean> hapticFeedbackEnabled = BooleanPreference.of("org.solovyev.android.calculator.CalculatorModel_haptic_feedback", false);
        public static final Preference<Long> hapticFeedbackDuration = NumberToStringPreference.of("org.solovyev.android.calculator.CalculatorActivity_calc_haptic_feedback_duration_key", 60L, Long.class);
    }
}

