/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.widget.ImageButton;
import org.solovyev.android.view.Picker;
import org.solovyev.android.view.R;

public class PickerButton
extends ImageButton {
    private Picker numberPicker;

    public PickerButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public PickerButton(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PickerButton(Context context) {
        super(context);
    }

    public void setNumberPicker(Picker picker) {
        this.numberPicker = picker;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.cancelLongPressIfRequired(event);
        return super.onTouchEvent(event);
    }

    public boolean onTrackballEvent(MotionEvent event) {
        this.cancelLongPressIfRequired(event);
        return super.onTrackballEvent(event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 23 || keyCode == 66) {
            this.cancelLongpress();
        }
        return super.onKeyUp(keyCode, event);
    }

    private void cancelLongPressIfRequired(MotionEvent event) {
        if (event.getAction() == 3 || event.getAction() == 1) {
            this.cancelLongpress();
        }
    }

    private void cancelLongpress() {
        if (R.id.increment == this.getId()) {
            this.numberPicker.cancelIncrement();
        } else if (R.id.decrement == this.getId()) {
            this.numberPicker.cancelDecrement();
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (!hasWindowFocus) {
            this.cancelLongpress();
        }
    }
}

