/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.view.PickerButton;
import org.solovyev.android.view.R;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Picker<T>
extends LinearLayout {
    @Nonnull
    private final Handler uiHandler = new Handler();
    @Nonnull
    private final Runnable runnable = new Runnable(){

        public void run() {
            if (Picker.this.increment) {
                Picker.this.changeCurrent(Picker.this.current + 1);
                Picker.this.uiHandler.postDelayed((Runnable)this, Picker.this.speed);
            } else if (Picker.this.decrement) {
                Picker.this.changeCurrent(Picker.this.current - 1);
                Picker.this.uiHandler.postDelayed((Runnable)this, Picker.this.speed);
            }
        }
    };
    @Nonnull
    private final TextView text;
    @Nonnull
    private Range<T> range;
    private int current;
    @Nullable
    private OnChangedListener<T> onChangedListener;
    private long speed = 300L;
    private boolean increment;
    private boolean decrement;
    @Nonnull
    private final PickerButton incrementButton;
    @Nonnull
    private final PickerButton decrementButton;

    public Picker(Context context) {
        this(context, null);
    }

    public Picker(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Picker);
        int orientation = a.getInt(R.styleable.Picker_orientation, 1);
        this.setOrientation(orientation);
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        if (orientation == 0) {
            inflater.inflate(R.layout.number_picker_horizontal, (ViewGroup)this, true);
        } else {
            inflater.inflate(R.layout.number_picker, (ViewGroup)this, true);
        }
        View.OnClickListener clickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (R.id.increment == v.getId()) {
                    Picker.this.changeCurrent(Picker.this.current + 1);
                } else if (R.id.decrement == v.getId()) {
                    Picker.this.changeCurrent(Picker.this.current - 1);
                }
            }
        };
        View.OnLongClickListener longClickListener = new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (R.id.increment == v.getId()) {
                    Picker.this.increment = true;
                    Picker.this.uiHandler.post(Picker.this.runnable);
                } else if (R.id.decrement == v.getId()) {
                    Picker.this.decrement = true;
                    Picker.this.uiHandler.post(Picker.this.runnable);
                }
                return true;
            }
        };
        this.incrementButton = (PickerButton)this.findViewById(R.id.increment);
        this.incrementButton.setNumberPicker(this);
        this.incrementButton.setOnClickListener(clickListener);
        this.incrementButton.setOnLongClickListener(longClickListener);
        this.decrementButton = (PickerButton)this.findViewById(R.id.decrement);
        this.decrementButton.setNumberPicker(this);
        this.decrementButton.setOnClickListener(clickListener);
        this.decrementButton.setOnLongClickListener(longClickListener);
        this.text = (TextView)this.findViewById(R.id.timepicker_input);
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.incrementButton.setEnabled(enabled);
        this.decrementButton.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }

    public void setOnChangeListener(OnChangedListener<T> listener) {
        this.onChangedListener = listener;
    }

    public void setRange(@Nonnull Range<T> range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/Picker.setRange must not be null");
        }
        this.range = range;
        this.current = range.getStartPosition();
        this.updateView();
    }

    public void setCurrent(int current) {
        if (current < 0 || current >= this.range.getCount()) {
            throw new IllegalArgumentException("Current: " + current + " should be >= 0 and < " + this.range.getCount());
        }
        this.current = current;
        this.updateView();
    }

    public void setSpeed(long speed) {
        this.speed = speed;
    }

    protected void changeCurrent(int current) {
        if (current < 0) {
            current = this.range.getCount() - 1;
        } else if (current >= this.range.getCount()) {
            current = 0;
        }
        this.current = current;
        this.notifyChange();
        this.updateView();
    }

    private void notifyChange() {
        if (this.onChangedListener != null) {
            this.onChangedListener.onChanged(this, this.range.getValueAt(this.current));
        }
    }

    private void updateView() {
        this.text.setText((CharSequence)this.range.getStringValueAt(this.current));
    }

    public void cancelIncrement() {
        this.increment = false;
    }

    public void cancelDecrement() {
        this.decrement = false;
    }

    public int getCurrent() {
        return this.current;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Range<T> {
        public int getStartPosition();

        public int getCount();

        @Nonnull
        public String getStringValueAt(int var1);

        @Nonnull
        public T getValueAt(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface OnChangedListener<T> {
        public void onChanged(@Nonnull Picker var1, @Nonnull T var2);
    }
}

