/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.view.Picker;
import org.solovyev.common.text.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListRange<T>
implements Picker.Range<T> {
    @Nonnull
    private List<T> elements;
    private int startPosition;
    @Nullable
    private Formatter<T> formatter;

    public ListRange(@Nonnull List<T> elements, @Nullable T selected) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/ListRange.<init> must not be null");
        }
        this.elements = elements;
        this.startPosition = elements.indexOf(selected);
        if (this.startPosition < 0) {
            this.startPosition = 0;
        }
        this.formatter = null;
    }

    public ListRange(@Nonnull List<T> elements, @Nullable T selected, @Nullable Formatter<T> formatter) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/ListRange.<init> must not be null");
        }
        this(elements, selected);
        this.formatter = formatter;
    }

    @Override
    public int getStartPosition() {
        return this.startPosition;
    }

    @Override
    public int getCount() {
        return this.elements.size();
    }

    @Override
    @Nonnull
    public String getStringValueAt(int position) {
        T value = this.getValueAt(position);
        String string2 = this.formatter == null ? value.toString() : this.formatter.formatValue(value);
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/ListRange.getStringValueAt must not return null");
        }
        return string2;
    }

    @Override
    @Nonnull
    public T getValueAt(int position) {
        T t = this.elements.get(position);
        if (t == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/ListRange.getValueAt must not return null");
        }
        return t;
    }
}

