/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.view.NumberRange;
import org.solovyev.common.text.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleRange
extends NumberRange<Double> {
    public DoubleRange(@Nonnull Double min, @Nonnull Double max, @Nonnull Double step, int startPosition, @Nullable Formatter<Double> formatter) {
        if (min == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/DoubleRange.<init> must not be null");
        }
        if (max == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/DoubleRange.<init> must not be null");
        }
        if (step == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/view/DoubleRange.<init> must not be null");
        }
        super(min, max, step, startPosition, formatter);
    }

    @Nonnull
    public static NumberRange<Double> newInstance(@Nonnull Double min, @Nonnull Double max, @Nonnull Double step, @Nonnull Double selected, @Nullable Formatter<Double> formatter) {
        if (min == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/DoubleRange.newInstance must not be null");
        }
        if (max == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/DoubleRange.newInstance must not be null");
        }
        if (step == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/view/DoubleRange.newInstance must not be null");
        }
        if (selected == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/solovyev/android/view/DoubleRange.newInstance must not be null");
        }
        if (selected < min || selected > max) {
            throw new IllegalArgumentException("Selected value: " + selected + " should be >= " + min + " and <= " + max + "!");
        }
        int startPosition = 0;
        for (double i = min.doubleValue(); i < selected; i += step.doubleValue()) {
            ++startPosition;
        }
        DoubleRange doubleRange = new DoubleRange(min, max, step, startPosition, formatter);
        if (doubleRange == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/DoubleRange.newInstance must not return null");
        }
        return doubleRange;
    }

    @Override
    protected int getCount(@Nonnull Double min, @Nonnull Double max, @Nonnull Double step) {
        if (min == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/DoubleRange.getCount must not be null");
        }
        if (max == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/DoubleRange.getCount must not be null");
        }
        if (step == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/view/DoubleRange.getCount must not be null");
        }
        int result = (int)((max - min) / step);
        return result + 1;
    }

    @Override
    @Nonnull
    protected Double getValueAt(int position, @Nonnull Double min, @Nonnull Double max, @Nonnull Double step) {
        if (min == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/DoubleRange.getValueAt must not be null");
        }
        if (max == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/view/DoubleRange.getValueAt must not be null");
        }
        if (step == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/solovyev/android/view/DoubleRange.getValueAt must not be null");
        }
        Double d = min + (double)position * step;
        if (d == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/DoubleRange.getValueAt must not return null");
        }
        return d;
    }
}

