/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.sherlock.menu;

import android.app.Activity;
import android.content.Context;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuItem;
import javax.annotation.Nonnull;
import org.solovyev.android.menu.AMenuItem;
import org.solovyev.android.menu.MenuHelper;
import org.solovyev.android.sherlock.AndroidSherlockUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SherlockMenuHelper
implements MenuHelper<Menu, MenuItem> {
    @Nonnull
    private static final SherlockMenuHelper instance = new SherlockMenuHelper();

    @Nonnull
    public static MenuHelper<Menu, MenuItem> getInstance() {
        SherlockMenuHelper sherlockMenuHelper = instance;
        if (sherlockMenuHelper == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/sherlock/menu/SherlockMenuHelper.getInstance must not return null");
        }
        return sherlockMenuHelper;
    }

    private SherlockMenuHelper() {
    }

    @Override
    public int size(@Nonnull Menu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/sherlock/menu/SherlockMenuHelper.size must not be null");
        }
        return menu.size();
    }

    @Override
    @Nonnull
    public MenuItem add(@Nonnull Menu menu, int groupId, int itemId, int orderId, @Nonnull String caption) {
        if (menu == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/sherlock/menu/SherlockMenuHelper.add must not be null");
        }
        if (caption == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of org/solovyev/android/sherlock/menu/SherlockMenuHelper.add must not be null");
        }
        MenuItem menuItem = menu.add(groupId, itemId, orderId, caption);
        if (menuItem == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/sherlock/menu/SherlockMenuHelper.add must not return null");
        }
        return menuItem;
    }

    @Override
    public void setOnMenuItemClickListener(final @Nonnull MenuItem menuItem, final @Nonnull AMenuItem<MenuItem> onMenuItemClick, final @Nonnull Activity activity) {
        if (menuItem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/sherlock/menu/SherlockMenuHelper.setOnMenuItemClickListener must not be null");
        }
        if (onMenuItemClick == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/sherlock/menu/SherlockMenuHelper.setOnMenuItemClickListener must not be null");
        }
        if (activity == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/sherlock/menu/SherlockMenuHelper.setOnMenuItemClickListener must not be null");
        }
        menuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                onMenuItemClick.onClick(menuItem, (Context)activity);
                return true;
            }
        });
    }

    @Override
    public void removeItem(@Nonnull Menu menu, @Nonnull Integer menuItemId) {
        if (menu == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/sherlock/menu/SherlockMenuHelper.removeItem must not be null");
        }
        if (menuItemId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/sherlock/menu/SherlockMenuHelper.removeItem must not be null");
        }
        menu.removeItem(menuItemId);
    }

    @Override
    public void inflateMenu(@Nonnull Activity activity, int layoutId, @Nonnull Menu menu) {
        if (activity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/sherlock/menu/SherlockMenuHelper.inflateMenu must not be null");
        }
        if (menu == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/sherlock/menu/SherlockMenuHelper.inflateMenu must not be null");
        }
        AndroidSherlockUtils.getSupportMenuInflater(activity).inflate(layoutId, menu);
    }

    @Override
    @Nonnull
    public Integer getItemId(@Nonnull MenuItem item) {
        if (item == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/sherlock/menu/SherlockMenuHelper.getItemId must not be null");
        }
        Integer n = item.getItemId();
        if (n == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/sherlock/menu/SherlockMenuHelper.getItemId must not return null");
        }
        return n;
    }
}

