/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.sherlock;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import com.actionbarsherlock.app.SherlockFragmentActivity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.sherlock.FragmentItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentItemImpl
implements FragmentItem {
    @Nonnull
    private final SherlockFragmentActivity activity;
    @Nonnull
    private final String tag;
    @Nonnull
    private final Class<? extends Fragment> fragmentClass;
    @Nullable
    private Bundle fragmentArgs;
    @Nullable
    private Fragment fragment;
    @Nullable
    private final Integer parentViewId;

    public FragmentItemImpl(@Nonnull SherlockFragmentActivity activity, @Nonnull String tag, @Nonnull Class<? extends Fragment> fragmentClass, @Nullable Bundle fragmentArgs, @Nullable Integer parentViewId) {
        if (activity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/sherlock/FragmentItemImpl.<init> must not be null");
        }
        if (tag == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/sherlock/FragmentItemImpl.<init> must not be null");
        }
        if (fragmentClass == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/sherlock/FragmentItemImpl.<init> must not be null");
        }
        this.activity = activity;
        this.tag = tag;
        this.fragmentClass = fragmentClass;
        this.fragmentArgs = fragmentArgs;
        this.parentViewId = parentViewId;
        FragmentManager supportFragmentManager = activity.getSupportFragmentManager();
        this.fragment = supportFragmentManager.findFragmentByTag(tag);
    }

    @Override
    public void onSelected(@Nonnull FragmentTransaction ft) {
        if (ft == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/sherlock/FragmentItemImpl.onSelected must not be null");
        }
        if (this.fragment == null) {
            this.fragment = this.activity.getSupportFragmentManager().findFragmentByTag(this.tag);
        }
        if (this.fragment == null) {
            this.fragment = Fragment.instantiate((Context)this.activity, (String)this.fragmentClass.getName(), (Bundle)this.fragmentArgs);
            if (this.parentViewId != null) {
                ft.add(this.parentViewId.intValue(), this.fragment, this.tag);
            } else {
                ft.add(this.fragment, this.tag);
            }
        } else if (this.fragment.isDetached()) {
            ft.attach(this.fragment);
        }
    }

    @Override
    public void onUnselected(@Nonnull FragmentTransaction ft) {
        if (ft == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/sherlock/FragmentItemImpl.onUnselected must not be null");
        }
        if (this.fragment != null) {
            ft.detach(this.fragment);
        }
    }
}

