/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.prefs;

import android.content.Context;
import android.util.AttributeSet;
import javax.annotation.Nonnull;
import org.solovyev.android.prefs.AbstractPickerDialogPreference;
import org.solovyev.android.view.NumberRange;
import org.solovyev.android.view.Picker;
import org.solovyev.common.interval.Interval;
import org.solovyev.common.text.NumberIntervalMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NumberPickerDialogPreference<N extends Number>
extends AbstractPickerDialogPreference<N> {
    @Nonnull
    private final Interval<N> boundaries;
    @Nonnull
    private final N step;

    protected NumberPickerDialogPreference(Context context, AttributeSet attrs, @Nonnull NumberIntervalMapper<N> mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/prefs/NumberPickerDialogPreference.<init> must not be null");
        }
        super(context, attrs, null, false, mapper.getMapper());
        this.boundaries = mapper.parseValue(attrs.getAttributeValue("http://schemas.android.com/apk/res-auto", "boundaries"));
        String stringStep = attrs.getAttributeValue("http://schemas.android.com/apk/res-auto", "step");
        this.step = stringStep == null ? this.getDefaultStep() : (Number)mapper.getMapper().parseValue(stringStep);
    }

    @Nonnull
    protected abstract N getDefaultStep();

    @Override
    @Nonnull
    protected Picker.Range<N> createRange(@Nonnull N selected) {
        if (selected == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/NumberPickerDialogPreference.createRange must not be null");
        }
        NumberRange<N> numberRange = this.createRange(this.boundaries, this.step, selected);
        if (numberRange == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/NumberPickerDialogPreference.createRange must not return null");
        }
        return numberRange;
    }

    @Nonnull
    protected abstract NumberRange<N> createRange(@Nonnull Interval<N> var1, @Nonnull N var2, @Nonnull N var3);
}

