/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.prefs;

import android.content.SharedPreferences;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.prefs.Preference;
import org.solovyev.android.prefs.StringPreference;
import org.solovyev.common.text.Mapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalePreference
implements Preference<Locale> {
    @Nonnull
    private final StringPreference<Locale> stringPreference;

    private LocalePreference(@Nonnull String id2, @Nullable Locale defaultValue, @Nonnull Mapper<Locale> localeMapper) {
        if (id2 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/LocalePreference.<init> must not be null");
        }
        if (localeMapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/prefs/LocalePreference.<init> must not be null");
        }
        this.stringPreference = new StringPreference<Locale>(id2, defaultValue, localeMapper);
    }

    private LocalePreference(@Nonnull String id2, @Nullable Locale defaultValue) {
        if (id2 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/LocalePreference.<init> must not be null");
        }
        this.stringPreference = new StringPreference<Locale>(id2, defaultValue, DefaultLocaleMapper.getInstance());
    }

    @Nonnull
    public static LocalePreference of(@Nonnull String id2, @Nullable Locale defaultValue, @Nonnull Mapper<Locale> localeMapper) {
        if (id2 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/LocalePreference.of must not be null");
        }
        if (localeMapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/prefs/LocalePreference.of must not be null");
        }
        LocalePreference localePreference = new LocalePreference(id2, defaultValue, localeMapper);
        if (localePreference == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/LocalePreference.of must not return null");
        }
        return localePreference;
    }

    @Nonnull
    public static LocalePreference of(@Nonnull String id2, @Nullable Locale defaultValue) {
        if (id2 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/LocalePreference.of must not be null");
        }
        LocalePreference localePreference = new LocalePreference(id2, defaultValue);
        if (localePreference == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/LocalePreference.of must not return null");
        }
        return localePreference;
    }

    @Override
    @Nonnull
    public String getKey() {
        String string2 = this.stringPreference.getKey();
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/LocalePreference.getKey must not return null");
        }
        return string2;
    }

    @Override
    public Locale getDefaultValue() {
        return (Locale)this.stringPreference.getDefaultValue();
    }

    @Override
    public Locale getPreference(@Nonnull SharedPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/LocalePreference.getPreference must not be null");
        }
        return (Locale)this.stringPreference.getPreference(preferences);
    }

    @Override
    public Locale getPreferenceNoError(@Nonnull SharedPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/LocalePreference.getPreferenceNoError must not be null");
        }
        return (Locale)this.stringPreference.getPreferenceNoError(preferences);
    }

    @Override
    public void putDefault(@Nonnull SharedPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/LocalePreference.putDefault must not be null");
        }
        this.stringPreference.putDefault(preferences);
    }

    @Override
    public void putPreference(@Nonnull SharedPreferences preferences, @Nullable Locale value) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/LocalePreference.putPreference must not be null");
        }
        this.stringPreference.putPreference(preferences, value);
    }

    @Override
    public boolean isSet(@Nonnull SharedPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/LocalePreference.isSet must not be null");
        }
        return this.stringPreference.isSet(preferences);
    }

    @Override
    public boolean tryPutDefault(@Nonnull SharedPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/LocalePreference.tryPutDefault must not be null");
        }
        return this.stringPreference.tryPutDefault(preferences);
    }

    @Override
    public boolean isSameKey(@Nonnull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/LocalePreference.isSameKey must not be null");
        }
        return this.stringPreference.isSameKey(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultLocaleMapper
    implements Mapper<Locale> {
        @Nonnull
        private static final String delimiter = ";";
        @Nonnull
        private static Mapper<Locale> instance = new DefaultLocaleMapper();

        private DefaultLocaleMapper() {
        }

        @Nonnull
        public static Mapper<Locale> getInstance() {
            Mapper<Locale> mapper = instance;
            if (mapper == null) {
                throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/LocalePreference$DefaultLocaleMapper.getInstance must not return null");
            }
            return mapper;
        }

        public String formatValue(@Nullable Locale locale) throws IllegalArgumentException {
            assert (locale != null);
            return locale.getLanguage() + delimiter + locale.getCountry() + delimiter + locale.getVariant();
        }

        public Locale parseValue(@Nullable String s) throws IllegalArgumentException {
            StringTokenizer st = new StringTokenizer(s, delimiter, false);
            String language = st.nextToken();
            String country = st.hasMoreTokens() ? st.nextToken() : "";
            String variant = st.hasMoreTokens() ? st.nextToken() : "";
            return new Locale(language, country, variant);
        }
    }
}

