/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.prefs;

import android.content.Context;
import android.util.AttributeSet;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.prefs.NumberPickerDialogPreference;
import org.solovyev.android.view.DoubleRange;
import org.solovyev.android.view.NumberRange;
import org.solovyev.common.interval.Interval;
import org.solovyev.common.text.Formatter;
import org.solovyev.common.text.NumberIntervalMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoublePickerDialogPreference
extends NumberPickerDialogPreference<Double> {
    @Nonnull
    private static final Formatter<Double> simpleFormatter = new DoubleFormatter(2);

    @Override
    @Nonnull
    protected Double getDefaultStep() {
        Double d = 1.0;
        if (d == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/DoublePickerDialogPreference.getDefaultStep must not return null");
        }
        return d;
    }

    @Override
    @Nonnull
    protected NumberRange<Double> createRange(@Nonnull Interval<Double> boundaries, @Nonnull Double step, @Nonnull Double selected) {
        if (boundaries == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/DoublePickerDialogPreference.createRange must not be null");
        }
        if (step == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/prefs/DoublePickerDialogPreference.createRange must not be null");
        }
        if (selected == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/prefs/DoublePickerDialogPreference.createRange must not be null");
        }
        NumberRange<Double> numberRange = DoubleRange.newInstance((Double)boundaries.getLeftLimit(), (Double)boundaries.getRightLimit(), step, selected, simpleFormatter);
        if (numberRange == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/DoublePickerDialogPreference.createRange must not return null");
        }
        return numberRange;
    }

    public DoublePickerDialogPreference(Context context, AttributeSet attrs) {
        super(context, attrs, NumberIntervalMapper.of(Double.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleFormatter
    implements Formatter<Double> {
        @Nonnull
        private final DecimalFormat df;

        private DoubleFormatter(int numberOfDecimalDigits) {
            StringBuilder sb = new StringBuilder("#.#");
            for (int i = 1; i < numberOfDecimalDigits; ++i) {
                sb.append("#");
            }
            this.df = new DecimalFormat(sb.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String formatValue(@Nullable Double value) throws IllegalArgumentException {
            if (value == null) {
                return "null";
            }
            DecimalFormat decimalFormat = this.df;
            synchronized (decimalFormat) {
                return this.df.format(value);
            }
        }
    }
}

