/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.prefs;

import android.content.SharedPreferences;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.prefs.Preference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPreference<T>
implements Preference<T> {
    @Nonnull
    private final String key;
    private final T defaultValue;

    protected AbstractPreference(@Nonnull String key, @Nullable T defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/AbstractPreference.<init> must not be null");
        }
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Override
    @Nonnull
    public String getKey() {
        String string2 = this.key;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/AbstractPreference.getKey must not return null");
        }
        return string2;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public final T getPreference(@Nonnull SharedPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/AbstractPreference.getPreference must not be null");
        }
        if (this.isSet(preferences)) {
            return this.getPersistedValue(preferences);
        }
        return this.defaultValue;
    }

    @Override
    public T getPreferenceNoError(@Nonnull SharedPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/AbstractPreference.getPreferenceNoError must not be null");
        }
        if (this.isSet(preferences)) {
            try {
                return this.getPersistedValue(preferences);
            }
            catch (RuntimeException e) {
                return this.defaultValue;
            }
        }
        return this.defaultValue;
    }

    @Override
    public void putDefault(@Nonnull SharedPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/AbstractPreference.putDefault must not be null");
        }
        this.putPreference(preferences, this.defaultValue);
    }

    @Override
    public void putPreference(@Nonnull SharedPreferences preferences, @Nullable T value) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/AbstractPreference.putPreference must not be null");
        }
        if (value != null) {
            SharedPreferences.Editor editor = preferences.edit();
            this.putPersistedValue(editor, value);
            editor.commit();
        }
    }

    @Override
    public boolean isSet(@Nonnull SharedPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/AbstractPreference.isSet must not be null");
        }
        return preferences.contains(this.key);
    }

    @Override
    public final boolean tryPutDefault(@Nonnull SharedPreferences preferences) {
        boolean result;
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/AbstractPreference.tryPutDefault must not be null");
        }
        if (this.isSet(preferences)) {
            result = false;
        } else {
            this.putDefault(preferences);
            result = true;
        }
        return result;
    }

    @Override
    public final boolean isSameKey(@Nonnull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/AbstractPreference.isSameKey must not be null");
        }
        return this.key.equals(key);
    }

    @Nullable
    protected abstract T getPersistedValue(@Nonnull SharedPreferences var1);

    protected abstract void putPersistedValue(@Nonnull SharedPreferences.Editor var1, @Nonnull T var2);
}

