/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.prefs;

import android.content.Context;
import android.preference.DialogPreference;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.common.Objects;
import org.solovyev.common.text.Mapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDialogPreference<T>
extends DialogPreference {
    @Nonnull
    protected static final String localNameSpace = "http://schemas.android.com/apk/res-auto";
    @Nonnull
    protected static final String androidns = "http://schemas.android.com/apk/res/android";
    @Nonnull
    private static final String TAG = AbstractDialogPreference.class.getSimpleName();
    @Nullable
    private TextView valueTextView;
    @Nullable
    private String valueText;
    @Nullable
    private View preferenceView;
    @Nonnull
    private final Context context;
    @Nullable
    private String description;
    @Nullable
    private T value;
    @Nullable
    private T defaultValue;
    @Nullable
    private final String defaultStringValue;
    private final boolean needValueText;
    @Nonnull
    private final Mapper<T> mapper;

    public AbstractDialogPreference(Context context, AttributeSet attrs, @Nullable String defaultStringValue, boolean needValueText, @Nonnull Mapper<T> mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of org/solovyev/android/prefs/AbstractDialogPreference.<init> must not be null");
        }
        super(context, attrs);
        this.context = context;
        this.defaultStringValue = defaultStringValue;
        this.needValueText = needValueText;
        this.mapper = mapper;
        String defaultValueFromAttrs = attrs.getAttributeValue(androidns, "defaultValue");
        if (defaultValueFromAttrs != null) {
            this.defaultValue = this.getMapper().parseValue(defaultValueFromAttrs);
        } else if (defaultStringValue != null) {
            this.defaultValue = this.getMapper().parseValue(defaultStringValue);
        } else {
            throw new IllegalArgumentException();
        }
        this.description = attrs.getAttributeValue(androidns, "dialogMessage");
        this.valueText = attrs.getAttributeValue(androidns, "text");
    }

    @Nullable
    protected View getPreferenceView() {
        return this.preferenceView;
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    public void setValue(@Nullable T value) {
        this.value = value;
    }

    @Nonnull
    protected final LinearLayout onCreateDialogView() {
        LinearLayout.LayoutParams params;
        if (this.shouldPersist()) {
            this.value = this.getPersistedValue();
        }
        LinearLayout result = new LinearLayout(this.context);
        result.setOrientation(1);
        result.setPadding(6, 6, 6, 6);
        if (this.description != null) {
            TextView splashText = new TextView(this.context);
            splashText.setText((CharSequence)this.description);
            result.addView((View)splashText);
        }
        if (this.needValueText) {
            this.valueTextView = new TextView(this.context);
            this.valueTextView.setGravity(1);
            this.valueTextView.setTextSize(32.0f);
            params = new LinearLayout.LayoutParams(-1, -2);
            result.addView((View)this.valueTextView, (ViewGroup.LayoutParams)params);
        }
        this.preferenceView = this.createPreferenceView(this.context);
        this.initPreferenceView(this.preferenceView, this.value);
        params = this.getParams();
        if (params != null) {
            result.addView(this.preferenceView, (ViewGroup.LayoutParams)params);
        } else {
            result.addView(this.preferenceView);
        }
        LinearLayout linearLayout = result;
        if (linearLayout == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/AbstractDialogPreference.onCreateDialogView must not return null");
        }
        return linearLayout;
    }

    @Nullable
    protected abstract LinearLayout.LayoutParams getParams();

    protected void onSetInitialValue(boolean restore, Object defaultValue) {
        super.onSetInitialValue(restore, defaultValue);
        if (restore) {
            this.value = this.shouldPersist() ? this.getPersistedValue() : this.defaultValue;
        } else {
            this.value = defaultValue;
            if (this.shouldPersist()) {
                this.persist(this.value);
            }
        }
    }

    protected void onBindDialogView(View v) {
        super.onBindDialogView(v);
        if (this.preferenceView != null) {
            this.initPreferenceView(this.preferenceView, this.value);
        }
    }

    @Nonnull
    protected abstract View createPreferenceView(@Nonnull Context var1);

    protected abstract void initPreferenceView(@Nonnull View var1, @Nullable T var2);

    @Nullable
    private T getPersistedValue() {
        String persistedString = this.getPersistedString(this.defaultStringValue);
        if (Objects.areEqual((Object)persistedString, (Object)this.defaultStringValue)) {
            return this.defaultValue;
        }
        return (T)this.getMapper().parseValue(persistedString);
    }

    protected void persistValue(@Nullable T value) {
        Log.d((String)TAG, (String)("Trying to persist value: " + value));
        this.value = value;
        Log.d((String)TAG, (String)"android.preference.Preference.callChangeListener()");
        if (this.callChangeListener(value)) {
            Log.d((String)TAG, (String)"android.preference.Preference.shouldPersist()");
            if (this.shouldPersist()) {
                Log.d((String)TAG, (String)"AbstractDialogPreference.persist()");
                this.persist(value);
            }
        }
    }

    private void persist(@Nullable T value) {
        String toBePersistedString;
        if (value != null && (toBePersistedString = this.getMapper().formatValue(value)) != null && this.callChangeListener(toBePersistedString)) {
            this.persistString(toBePersistedString);
        }
    }

    @Nullable
    public String getValueText() {
        return this.valueText;
    }

    protected void updateValueText(@Nonnull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/AbstractDialogPreference.updateValueText must not be null");
        }
        if (this.valueTextView != null) {
            this.valueTextView.setText((CharSequence)text);
        }
    }

    @Nonnull
    private Mapper<T> getMapper() {
        Mapper<T> mapper = this.mapper;
        if (mapper == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/AbstractDialogPreference.getMapper must not return null");
        }
        return mapper;
    }
}

