/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.menu;

import android.app.Activity;
import android.content.Context;
import android.view.Menu;
import android.view.MenuItem;
import javax.annotation.Nonnull;
import org.solovyev.android.menu.AMenuItem;
import org.solovyev.android.menu.MenuHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AndroidMenuHelper
implements MenuHelper<Menu, MenuItem> {
    @Nonnull
    private static final AndroidMenuHelper instance = new AndroidMenuHelper();

    @Nonnull
    public static MenuHelper<Menu, MenuItem> getInstance() {
        AndroidMenuHelper androidMenuHelper = instance;
        if (androidMenuHelper == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/AndroidMenuHelper.getInstance must not return null");
        }
        return androidMenuHelper;
    }

    private AndroidMenuHelper() {
    }

    @Override
    public int size(@Nonnull Menu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/AndroidMenuHelper.size must not be null");
        }
        return menu.size();
    }

    @Override
    @Nonnull
    public MenuItem add(@Nonnull Menu menu, int groupId, int itemId, int orderId, @Nonnull String caption) {
        if (menu == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/AndroidMenuHelper.add must not be null");
        }
        if (caption == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of org/solovyev/android/menu/AndroidMenuHelper.add must not be null");
        }
        MenuItem menuItem = menu.add(groupId, itemId, orderId, (CharSequence)caption);
        if (menuItem == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/AndroidMenuHelper.add must not return null");
        }
        return menuItem;
    }

    @Override
    public void setOnMenuItemClickListener(final @Nonnull MenuItem menuItem, final @Nonnull AMenuItem<MenuItem> onMenuItemClick, final @Nonnull Activity activity) {
        if (menuItem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/AndroidMenuHelper.setOnMenuItemClickListener must not be null");
        }
        if (onMenuItemClick == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/AndroidMenuHelper.setOnMenuItemClickListener must not be null");
        }
        if (activity == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/menu/AndroidMenuHelper.setOnMenuItemClickListener must not be null");
        }
        menuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                onMenuItemClick.onClick(menuItem, (Context)activity);
                return true;
            }
        });
    }

    @Override
    public void removeItem(@Nonnull Menu menu, @Nonnull Integer menuItemId) {
        if (menu == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/AndroidMenuHelper.removeItem must not be null");
        }
        if (menuItemId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/AndroidMenuHelper.removeItem must not be null");
        }
        menu.removeItem(menuItemId.intValue());
    }

    @Override
    public void inflateMenu(@Nonnull Activity activity, int layoutId, @Nonnull Menu menu) {
        if (activity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/AndroidMenuHelper.inflateMenu must not be null");
        }
        if (menu == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/menu/AndroidMenuHelper.inflateMenu must not be null");
        }
        activity.getMenuInflater().inflate(layoutId, menu);
    }

    @Override
    @Nonnull
    public Integer getItemId(@Nonnull MenuItem item) {
        if (item == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/AndroidMenuHelper.getItemId must not be null");
        }
        Integer n = item.getItemId();
        if (n == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/AndroidMenuHelper.getItemId must not return null");
        }
        return n;
    }
}

