/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.list;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.common.JPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixFilter<T>
implements JPredicate<T> {
    @Nonnull
    private String prefix;

    public PrefixFilter(@Nonnull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/list/PrefixFilter.<init> must not be null");
        }
        this.prefix = prefix;
    }

    public boolean apply(@Nullable T input) {
        boolean shown = false;
        if (input != null) {
            String valueText = input.toString().toLowerCase();
            if (valueText.startsWith(this.prefix)) {
                shown = true;
            } else {
                String[] words;
                for (String word : words = valueText.split(" ")) {
                    if (!word.startsWith(this.prefix)) continue;
                    shown = true;
                    break;
                }
            }
        }
        return shown;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PrefixFilter) {
            PrefixFilter that = (PrefixFilter)o;
            if (this.prefix.equals(that.prefix)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.prefix.hashCode();
    }
}

