/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.list;

import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.widget.ListView;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ListAnimator {
    @Nonnull
    private final ListView listView;
    @Nonnull
    private final AnimationType animationType;
    @Nullable
    private final Runnable postAction;

    public ListAnimator(@Nonnull ListView listView, @Nonnull AnimationType animationType, @Nullable Runnable postAction) {
        if (listView == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/list/ListAnimator.<init> must not be null");
        }
        if (animationType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/list/ListAnimator.<init> must not be null");
        }
        this.listView = listView;
        this.animationType = animationType;
        this.postAction = postAction;
    }

    public void animate() {
        AnimationSet animationSet = new AnimationSet(false);
        AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.25f);
        alphaAnimation.setDuration(350L);
        animationSet.addAnimation((Animation)alphaAnimation);
        Animation moveAnimation = this.animationType.create();
        moveAnimation.setDuration(500L);
        animationSet.addAnimation(moveAnimation);
        animationSet.setRepeatCount(0);
        if (this.postAction != null) {
            animationSet.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    ListAnimator.this.postAction.run();
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        }
        this.listView.startAnimation((Animation)animationSet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AnimationType {
        left_to_right{

            @Nonnull
            public Animation create() {
                TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, -1.0f, 1, 0.0f, 1, 0.0f);
                if (translateAnimation == null) {
                    throw new IllegalStateException("@NotNull method org/solovyev/android/list/ListAnimator$AnimationType$1.create must not return null");
                }
                return translateAnimation;
            }
        }
        ,
        right_to_left{

            @Nonnull
            public Animation create() {
                TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, 1.0f, 1, 0.0f, 1, 0.0f);
                if (translateAnimation == null) {
                    throw new IllegalStateException("@NotNull method org/solovyev/android/list/ListAnimator$AnimationType$2.create must not return null");
                }
                return translateAnimation;
            }
        }
        ,
        top_to_bottom{

            @Nonnull
            public Animation create() {
                TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
                if (translateAnimation == null) {
                    throw new IllegalStateException("@NotNull method org/solovyev/android/list/ListAnimator$AnimationType$3.create must not return null");
                }
                return translateAnimation;
            }
        };


        @Nonnull
        public abstract Animation create();
    }
}

