/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.list;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.list.AdapterFilter;
import org.solovyev.android.list.PrefixAdapterFilter;
import org.solovyev.common.Objects;
import org.solovyev.common.text.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListAdapter<T>
extends BaseAdapter
implements Filterable {
    @Nonnull
    private static final String FILTER_TEXT = "filter_text";
    @Nonnull
    private List<T> shownElements;
    @Nullable
    private List<T> allElements;
    private final Object lock;
    private int resources;
    private int dropDownResource;
    private final int fieldId;
    private boolean notifyOnChange;
    private boolean resortAndRefilter;
    @Nullable
    private String filterText;
    @Nonnull
    private final Context context;
    @Nullable
    private Filter filter;
    @Nonnull
    private final LayoutInflater inflater;
    @Nonnull
    private final AdapterHelper adapterHelper;

    public ListAdapter(@Nonnull Context context, int textViewResourceId) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/list/ListAdapter.<init> must not be null");
        }
        this(context, textViewResourceId, 0, new ArrayList());
    }

    public ListAdapter(Context context, int resource, int textViewResourceId) {
        this(context, resource, textViewResourceId, new ArrayList());
    }

    public ListAdapter(@Nonnull Context context, int textViewResourceId, @Nonnull T[] elements) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/list/ListAdapter.<init> must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/list/ListAdapter.<init> must not be null");
        }
        this(context, textViewResourceId, 0, Arrays.asList(elements));
    }

    public ListAdapter(@Nonnull Context context, int resource, int textViewResourceId, @Nonnull T[] elements) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/list/ListAdapter.<init> must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/solovyev/android/list/ListAdapter.<init> must not be null");
        }
        this(context, resource, textViewResourceId, Arrays.asList(elements));
    }

    public ListAdapter(@Nonnull Context context, int textViewResourceId, @Nonnull List<T> elements) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/list/ListAdapter.<init> must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/list/ListAdapter.<init> must not be null");
        }
        this(context, textViewResourceId, 0, elements);
    }

    public ListAdapter(@Nonnull Context context, int resource, int textViewResourceId, @Nonnull List<T> elements) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/list/ListAdapter.<init> must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/solovyev/android/list/ListAdapter.<init> must not be null");
        }
        this.lock = new Object();
        this.notifyOnChange = true;
        this.resortAndRefilter = true;
        this.context = context;
        this.inflater = LayoutInflater.from((Context)context);
        this.resources = this.dropDownResource = resource;
        this.shownElements = elements;
        this.fieldId = textViewResourceId;
        this.adapterHelper = new AdapterHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T object) {
        boolean changed;
        Object object2 = this.lock;
        synchronized (object2) {
            changed = this.allElements != null ? this.allElements.add(object) : this.shownElements.add(object);
            this.tryResortAndRefilter(changed);
        }
        this.tryNotifyDataSetChanged(changed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDataSetChanged(boolean resortAndRefilter) {
        if (resortAndRefilter) {
            Object object = this.lock;
            synchronized (object) {
                this.tryResortAndRefilter(true);
            }
        }
        this.tryNotifyDataSetChanged(true);
    }

    protected final void onDataSetChanged() {
        this.onDataSetChanged(true);
    }

    private void tryResortAndRefilter(boolean changed) {
        if (changed && this.resortAndRefilter) {
            this.resort();
            this.refilter();
        }
    }

    private void resort() {
        assert (Thread.holdsLock(this.lock));
        Comparator<T> comparator = this.getComparator();
        if (comparator != null) {
            this.sort(comparator, false);
        }
    }

    private void tryNotifyDataSetChanged(boolean changed) {
        assert (!Thread.holdsLock(this.lock));
        if (changed && this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<? extends T> collection) {
        boolean changed;
        Object object = this.lock;
        synchronized (object) {
            changed = this.allElements != null ? this.allElements.addAll(collection) : this.shownElements.addAll(collection);
            this.tryResortAndRefilter(changed);
        }
        this.tryNotifyDataSetChanged(changed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(T ... items) {
        boolean changed;
        Object object = this.lock;
        synchronized (object) {
            changed = this.allElements != null ? Collections.addAll(this.allElements, items) : Collections.addAll(this.shownElements, items);
            this.tryResortAndRefilter(changed);
        }
        this.tryNotifyDataSetChanged(changed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(T object, int index) {
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.allElements != null) {
                this.allElements.add(index, object);
            } else {
                this.shownElements.add(index, object);
            }
            this.tryResortAndRefilter(true);
        }
        this.tryNotifyDataSetChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T object) {
        boolean changed;
        Object object2 = this.lock;
        synchronized (object2) {
            changed = this.allElements != null ? this.allElements.remove(object) : this.shownElements.remove(object);
            this.tryResortAndRefilter(changed);
        }
        this.tryNotifyDataSetChanged(changed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAt(int position) {
        boolean changed;
        Object object = this.lock;
        synchronized (object) {
            changed = this.allElements != null ? this.allElements.remove(position) != null : this.shownElements.remove(position) != null;
            this.tryResortAndRefilter(changed);
        }
        this.tryNotifyDataSetChanged(changed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        boolean changed;
        Object object = this.lock;
        synchronized (object) {
            if (this.allElements != null) {
                changed = !this.allElements.isEmpty();
                this.allElements.clear();
            } else {
                changed = !this.shownElements.isEmpty();
                this.shownElements.clear();
            }
            this.tryResortAndRefilter(changed);
        }
        this.tryNotifyDataSetChanged(changed);
    }

    public void sort(Comparator<? super T> comparator) {
        this.sort(comparator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sort(Comparator<? super T> comparator, boolean notify) {
        Object object = this.lock;
        synchronized (object) {
            Collections.sort(this.shownElements, comparator);
            if (this.allElements != null) {
                Collections.sort(this.allElements, comparator);
            }
        }
        if (notify) {
            this.tryNotifyDataSetChanged(true);
        }
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.notifyOnChange = true;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.notifyOnChange = notifyOnChange;
    }

    @Nonnull
    public Context getContext() {
        Context context = this.context;
        if (context == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/list/ListAdapter.getContext must not return null");
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.shownElements.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getItem(int position) {
        Object object = this.lock;
        synchronized (object) {
            return this.shownElements.get(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPosition(T item) {
        Object object = this.lock;
        synchronized (object) {
            return this.shownElements.indexOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsInShown(@Nonnull T element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/list/ListAdapter.containsInShown must not be null");
        }
        Object object = this.lock;
        synchronized (object) {
            return this.shownElements.contains(element);
        }
    }

    public boolean containsInAll(@Nonnull T element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/list/ListAdapter.containsInAll must not be null");
        }
        return this.getAllElements().contains(element);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.createViewFromResource(position, convertView, parent, this.resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(@Nonnull Runnable runnable) {
        boolean notifyOnChange;
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/list/ListAdapter.doWork must not be null");
        }
        Object object = this.lock;
        synchronized (object) {
            notifyOnChange = this.isNotifyOnChange();
            try {
                this.resortAndRefilter = false;
                this.setNotifyOnChange(false);
                runnable.run();
            }
            finally {
                this.setNotifyOnChange(notifyOnChange);
                this.resortAndRefilter = true;
            }
            this.tryResortAndRefilter(true);
        }
        if (notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    private View createViewFromResource(int position, @Nullable View convertView, ViewGroup parent, int resource) {
        TextView text;
        View view = convertView != null ? convertView : this.inflater.inflate(resource, parent, false);
        try {
            text = this.fieldId == 0 ? (TextView)view : (TextView)view.findViewById(this.fieldId);
        }
        catch (ClassCastException e) {
            Log.e((String)"ListAdapter", (String)"You must supply a resource ID for a TextView");
            throw new IllegalStateException("ListAdapter requires the resource ID to be a TextView", e);
        }
        T item = this.getItem(position);
        if (item instanceof CharSequence) {
            text.setText((CharSequence)item);
        } else {
            text.setText((CharSequence)item.toString());
        }
        return view;
    }

    public void setDropDownViewResource(int resource) {
        this.dropDownResource = resource;
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.createViewFromResource(position, convertView, parent, this.dropDownResource);
    }

    public static ListAdapter<CharSequence> createFromResource(Context context, int textArrayResId, int textViewResId) {
        CharSequence[] strings = context.getResources().getTextArray(textArrayResId);
        return new ListAdapter<CharSequence>(context, textViewResId, strings);
    }

    public final Filter getFilter() {
        if (this.filter == null) {
            this.filter = this.createFilter();
        }
        return this.filter;
    }

    @Nonnull
    protected Filter createFilter() {
        PrefixAdapterFilter prefixAdapterFilter = new PrefixAdapterFilter(this.adapterHelper);
        if (prefixAdapterFilter == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/list/ListAdapter.createFilter must not return null");
        }
        return prefixAdapterFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Nonnull
    protected List<T> getShownElements() {
        Object object = this.lock;
        // MONITORENTER : object
        List<T> list = Collections.unmodifiableList(this.shownElements);
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method org/solovyev/android/list/ListAdapter.getShownElements must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Nonnull
    protected List<T> getAllElements() {
        Object object = this.lock;
        // MONITORENTER : object
        List<T> list = Collections.unmodifiableList(this.allElements == null ? this.shownElements : this.allElements);
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method org/solovyev/android/list/ListAdapter.getAllElements must not return null");
    }

    @Nullable
    protected Comparator<? super T> getComparator() {
        return null;
    }

    public void saveState(@Nonnull Bundle outState) {
        if (outState == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/list/ListAdapter.saveState must not be null");
        }
        if (this.filterText != null) {
            outState.putString(FILTER_TEXT, this.filterText.toString());
        }
    }

    public void restoreState(@Nonnull Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/list/ListAdapter.restoreState must not be null");
        }
        this.filterText = savedInstanceState.getString(FILTER_TEXT);
    }

    @Nonnull
    protected AdapterHelper getAdapterHelper() {
        AdapterHelper adapterHelper = this.adapterHelper;
        if (adapterHelper == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/list/ListAdapter.getAdapterHelper must not return null");
        }
        return adapterHelper;
    }

    public boolean isNotifyOnChange() {
        return this.notifyOnChange;
    }

    public void filter(@Nullable String filterText) {
        this.filter(filterText, null);
    }

    private boolean isSameFilterText(@Nullable String filterText) {
        if (Objects.areEqual((Object)this.filterText, (Object)filterText)) {
            return true;
        }
        return Strings.isEmpty((CharSequence)this.filterText) && Strings.isEmpty((CharSequence)filterText);
    }

    public void filter(@Nullable String filterText, @Nullable Filter.FilterListener listener) {
        if (!this.isSameFilterText(filterText)) {
            this.filterText = filterText;
            this.getFilter().filter((CharSequence)filterText, listener);
        } else if (listener != null) {
            listener.onFilterComplete(this.getCount());
        }
    }

    public void refilter() {
        this.getFilter().filter((CharSequence)this.filterText);
    }

    @Nullable
    public CharSequence getFilterText() {
        return this.filterText;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AdapterHelper
    implements AdapterFilter.Helper<T> {
        @Override
        @Nonnull
        public Object getLock() {
            Object object = ListAdapter.this.lock;
            if (object == null) {
                throw new IllegalStateException("@NotNull method org/solovyev/android/list/ListAdapter$AdapterHelper.getLock must not return null");
            }
            return object;
        }

        @Override
        @Nonnull
        public List<T> getShownElements() {
            List list = ListAdapter.this.shownElements;
            if (list == null) {
                throw new IllegalStateException("@NotNull method org/solovyev/android/list/ListAdapter$AdapterHelper.getShownElements must not return null");
            }
            return list;
        }

        @Override
        public void setShownElements(@Nonnull List<T> shownElements) {
            if (shownElements == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/list/ListAdapter$AdapterHelper.setShownElements must not be null");
            }
            ListAdapter.this.shownElements = shownElements;
        }

        @Override
        @Nullable
        public List<T> getAllElements() {
            return ListAdapter.this.allElements;
        }

        @Override
        public void setAllElements(@Nullable List<T> allElements) {
            ListAdapter.this.allElements = allElements;
        }

        @Override
        public void notifyDataSetChanged() {
            if (ListAdapter.this.notifyOnChange) {
                ListAdapter.this.notifyDataSetChanged();
            }
        }
    }
}

