/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.list;

import android.widget.Filter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.common.JPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdapterFilter<T>
extends Filter {
    @Nonnull
    private final Helper<T> helper;

    public AdapterFilter(@Nonnull Helper<T> helper) {
        if (helper == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/list/AdapterFilter.<init> must not be null");
        }
        this.helper = helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected FilterResults performFiltering(@Nullable CharSequence prefix) {
        ArrayList<T> allElements;
        List<T> filteredElements;
        FilterResults results = new FilterResults();
        if (!(prefix != null && prefix.length() != 0 || this.doFilterOnEmptyString())) {
            filteredElements = this.getAllElements();
            allElements = null;
        } else {
            JPredicate<T> filter = this.getFilter(prefix);
            Object object = this.helper.getLock();
            synchronized (object) {
                allElements = new ArrayList<T>(this.getAllElements());
            }
            filteredElements = new ArrayList<T>(allElements.size());
            for (Object element : allElements) {
                if (!filter.apply(element)) continue;
                filteredElements.add(element);
            }
        }
        results.values = filteredElements;
        results.allElements = allElements;
        results.count = filteredElements.size();
        FilterResults filterResults = results;
        if (filterResults == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/list/AdapterFilter.performFiltering must not return null");
        }
        return filterResults;
    }

    @Nonnull
    private List<T> getAllElements() {
        List<T> result = this.helper.getAllElements();
        if (result == null) {
            result = this.helper.getShownElements();
        }
        List<T> list = result;
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/list/AdapterFilter.getAllElements must not return null");
        }
        return list;
    }

    protected boolean doFilterOnEmptyString() {
        return false;
    }

    protected abstract JPredicate<T> getFilter(@Nullable CharSequence var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
        boolean changed = false;
        Object object = this.helper.getLock();
        synchronized (object) {
            if (results.values != this.helper.getShownElements()) {
                this.helper.setShownElements((List)results.values);
                changed = true;
            }
            if (((FilterResults)results).allElements != this.helper.getAllElements()) {
                this.helper.setAllElements(((FilterResults)results).allElements);
                changed = true;
            }
        }
        if (changed) {
            this.helper.notifyDataSetChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilterResults<T>
    extends Filter.FilterResults {
        @Nullable
        private List<T> allElements;

        private FilterResults() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Helper<T> {
        @Nonnull
        public Object getLock();

        @Nonnull
        public List<T> getShownElements();

        public void setShownElements(@Nonnull List<T> var1);

        @Nullable
        public List<T> getAllElements();

        public void setAllElements(@Nullable List<T> var1);

        public void notifyDataSetChanged();
    }
}

