/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.history;

import android.util.Log;
import android.view.MotionEvent;
import javax.annotation.Nonnull;
import org.solovyev.android.view.drag.DragButton;
import org.solovyev.android.view.drag.DragDirection;
import org.solovyev.android.view.drag.SimpleOnDragListener;
import org.solovyev.common.history.HistoryAction;
import org.solovyev.common.history.HistoryControl;
import org.solovyev.common.math.Point2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryDragProcessor<T>
implements SimpleOnDragListener.DragProcessor {
    @Nonnull
    private final HistoryControl<T> historyControl;

    public HistoryDragProcessor(@Nonnull HistoryControl<T> historyControl) {
        if (historyControl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/history/HistoryDragProcessor.<init> must not be null");
        }
        this.historyControl = historyControl;
    }

    @Override
    public boolean processDragEvent(@Nonnull DragDirection dragDirection, @Nonnull DragButton dragButton, @Nonnull Point2d startPoint2d, @Nonnull MotionEvent motionEvent) {
        if (dragDirection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/history/HistoryDragProcessor.processDragEvent must not be null");
        }
        if (dragButton == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/history/HistoryDragProcessor.processDragEvent must not be null");
        }
        if (startPoint2d == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/history/HistoryDragProcessor.processDragEvent must not be null");
        }
        if (motionEvent == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/solovyev/android/history/HistoryDragProcessor.processDragEvent must not be null");
        }
        boolean result = false;
        Log.d((String)String.valueOf(dragButton.getId()), (String)("History on drag event start: " + (Object)((Object)dragDirection)));
        Object historyAction = dragDirection == DragDirection.up ? HistoryAction.undo : (dragDirection == DragDirection.down ? HistoryAction.redo : null);
        if (historyAction != null) {
            result = true;
            this.historyControl.doHistoryAction(historyAction);
        }
        return result;
    }
}

