/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TabHost;
import android.widget.TextView;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.Android;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Views {
    private static final boolean AT_LEAST_API_5 = Build.VERSION.SDK_INT >= 5;

    private Views() {
        throw new AssertionError();
    }

    public static void processViews(@Nonnull View view, @Nonnull ViewProcessor<View> viewProcessor) {
        if (view == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Views.processViews must not be null");
        }
        if (viewProcessor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/Views.processViews must not be null");
        }
        Views.processViewsOfType0(view, null, viewProcessor);
    }

    static <T> void processViewsOfType0(@Nonnull View view, @Nullable Class<T> viewClass, @Nonnull ViewProcessor<T> viewProcessor) {
        if (view == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Views.processViewsOfType0 must not be null");
        }
        if (viewProcessor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/Views.processViewsOfType0 must not be null");
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            if (viewClass == null || viewClass.isAssignableFrom(ViewGroup.class)) {
                viewProcessor.process(viewGroup);
            }
            for (int index = 0; index < viewGroup.getChildCount(); ++index) {
                Views.processViewsOfType0(viewGroup.getChildAt(index), viewClass, viewProcessor);
            }
        } else if (viewClass == null || viewClass.isAssignableFrom(view.getClass())) {
            viewProcessor.process(view);
        }
    }

    public static <T> void processViewsOfType(@Nonnull View view, @Nonnull Class<T> viewClass, @Nonnull ViewProcessor<T> viewProcessor) {
        if (view == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Views.processViewsOfType must not be null");
        }
        if (viewClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/Views.processViewsOfType must not be null");
        }
        if (viewProcessor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/Views.processViewsOfType must not be null");
        }
        Views.processViewsOfType0(view, viewClass, viewProcessor);
    }

    public static void centerAndWrapTabsFor(@Nonnull TabHost tabHost) {
        if (tabHost == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Views.centerAndWrapTabsFor must not be null");
        }
        if (Views.allowCenterAndWrappingTabs()) {
            int tabCount = tabHost.getTabWidget().getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                View textView;
                View view = tabHost.getTabWidget().getChildTabViewAt(i);
                if (view == null) continue;
                if (view.getLayoutParams().height > 0) {
                    view.getLayoutParams().height = (int)((double)view.getLayoutParams().height * 0.8);
                }
                if (!((textView = view.findViewById(16908310)) instanceof TextView)) continue;
                ((TextView)textView).setGravity(17);
                ((TextView)textView).setSingleLine(false);
                textView.getLayoutParams().height = -1;
                textView.getLayoutParams().width = -2;
            }
        }
    }

    private static boolean allowCenterAndWrappingTabs() {
        String buildId;
        boolean result = true;
        String deviceModel = Build.MODEL;
        if (deviceModel != null && ((deviceModel = deviceModel.toUpperCase()).contains("M1") || deviceModel.contains("MIONE") || deviceModel.contains("MI-ONE"))) {
            result = false;
            Log.i((String)Android.class.getName(), (String)("Device model doesn't support center and wrap of tabs: " + Build.MODEL));
        }
        if (result && (buildId = Build.DISPLAY) != null && (buildId = buildId.toUpperCase()).contains("MIUI")) {
            result = false;
            Log.i((String)Android.class.getName(), (String)("Device build doesn't support center and wrap of tabs: " + Build.DISPLAY));
        }
        return result;
    }

    public static void addTab(@Nonnull Context context, @Nonnull TabHost tabHost, @Nonnull String tabId, int tabCaptionId, @Nonnull Class<? extends Activity> activityClass) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Views.addTab must not be null");
        }
        if (tabHost == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/Views.addTab must not be null");
        }
        if (tabId == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/Views.addTab must not be null");
        }
        if (activityClass == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of org/solovyev/android/Views.addTab must not be null");
        }
        Intent intent = new Intent().setClass(context, activityClass);
        TabHost.TabSpec tabSpec = tabHost.newTabSpec(tabId).setIndicator((CharSequence)context.getString(tabCaptionId)).setContent(intent);
        tabHost.addTab(tabSpec);
    }

    public static int toPixels(@Nonnull DisplayMetrics dm, float dps) {
        if (dm == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Views.toPixels must not be null");
        }
        float scale = dm.density;
        return (int)(dps * scale + 0.5f);
    }

    public static int getScreenOrientation(@Nonnull Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Views.getScreenOrientation must not be null");
        }
        Display display = activity.getWindowManager().getDefaultDisplay();
        int result = display.getWidth() <= display.getHeight() ? 1 : 2;
        return result;
    }

    public static boolean isLayoutSizeAtLeast(int size, @Nonnull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/Views.isLayoutSizeAtLeast must not be null");
        }
        int cur = configuration.screenLayout & 0xF;
        if (cur == 0) {
            return false;
        }
        return cur >= size;
    }

    public static int getPointerCountFromMotionEvent(@Nonnull MotionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Views.getPointerCountFromMotionEvent must not be null");
        }
        return AT_LEAST_API_5 ? event.getPointerCount() : 1;
    }

    public static float getXFromMotionEvent(@Nonnull MotionEvent event, int pointer) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Views.getXFromMotionEvent must not be null");
        }
        return AT_LEAST_API_5 ? event.getX(pointer) : 0.0f;
    }

    public static float getYFromMotionEvent(@Nonnull MotionEvent event, int pointer) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Views.getYFromMotionEvent must not be null");
        }
        return AT_LEAST_API_5 ? event.getY(pointer) : 0.0f;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ViewProcessor<V> {
        public void process(@Nonnull V var1);
    }
}

