/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android;

import android.app.TabActivity;
import android.content.Context;
import android.preference.PreferenceManager;
import android.widget.TabHost;
import javax.annotation.Nonnull;
import org.solovyev.android.prefs.StringPreference;

public class LastTabSaver
implements TabHost.OnTabChangeListener {
    private static final String LAST_OPENED_TAB_P_KEY = "last_opened_tab_";
    @Nonnull
    private final StringPreference<String> preference;
    @Nonnull
    private final TabActivity tabActivity;

    public LastTabSaver(@Nonnull TabActivity tabActivity, @Nonnull String defaultTabId) {
        if (tabActivity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/LastTabSaver.<init> must not be null");
        }
        if (defaultTabId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/LastTabSaver.<init> must not be null");
        }
        this.tabActivity = tabActivity;
        this.preference = StringPreference.of(this.getPreferenceKey(), defaultTabId);
        TabHost tabHost = tabActivity.getTabHost();
        tabHost.setCurrentTabByTag(this.getLastOpenedTabId());
        tabHost.setOnTabChangedListener((TabHost.OnTabChangeListener)this);
    }

    public void destroy() {
        TabHost tabHost = this.tabActivity.getTabHost();
        tabHost.setOnTabChangedListener(null);
    }

    public void onTabChanged(String tabId) {
        this.preference.putPreference(PreferenceManager.getDefaultSharedPreferences((Context)this.tabActivity), tabId);
    }

    @Nonnull
    public String getLastOpenedTabId() {
        String string2 = (String)this.preference.getPreference(PreferenceManager.getDefaultSharedPreferences((Context)this.tabActivity));
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/LastTabSaver.getLastOpenedTabId must not return null");
        }
        return string2;
    }

    @Nonnull
    private String getPreferenceKey() {
        String string2 = LAST_OPENED_TAB_P_KEY + this.tabActivity.getClass().getName();
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/LastTabSaver.getPreferenceKey must not return null");
        }
        return string2;
    }
}

