/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FileCache {
    @Nonnull
    private final File cacheDir;

    public FileCache(@Nonnull Context context, @Nonnull String cacheFileName) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/FileCache.<init> must not be null");
        }
        if (cacheFileName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/FileCache.<init> must not be null");
        }
        this.cacheDir = Environment.getExternalStorageState().equals("mounted") ? new File(this.createExternalCachePath(context), cacheFileName) : new File(this.createInternalCachePath(context), cacheFileName);
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
        }
    }

    @Nullable
    private String createExternalCachePath(@Nonnull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/FileCache.createExternalCachePath must not be null");
        }
        if (Build.VERSION.SDK_INT >= 8) {
            File cacheDir = context.getExternalCacheDir();
            return cacheDir != null ? cacheDir.getPath() : this.createInternalCachePath(context);
        }
        return Environment.getExternalStorageDirectory().getPath() + "/Android/data/" + context.getPackageName() + "/cache";
    }

    @Nullable
    private String createInternalCachePath(@Nonnull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/FileCache.createInternalCachePath must not be null");
        }
        File cacheDir = context.getCacheDir();
        return cacheDir != null ? cacheDir.getPath() : null;
    }

    @Nonnull
    public File getFile(@Nonnull String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/FileCache.getFile must not be null");
        }
        File file = new File(this.cacheDir, filename);
        if (file == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/FileCache.getFile must not return null");
        }
        return file;
    }

    public void clear() {
        File[] files = this.cacheDir.listFiles();
        if (files != null) {
            for (File file : files) {
                file.delete();
            }
        }
    }
}

