/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android;

import android.app.AlertDialog;
import android.app.Dialog;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.Fragments;

public class DialogFragmentShower {
    @Nonnull
    private final FragmentActivity fragmentActivity;
    @Nonnull
    private final String fragmentTag;
    @Nonnull
    private final AlertDialog.Builder menuBuilder;

    public DialogFragmentShower(@Nonnull FragmentActivity fragmentActivity, @Nonnull String fragmentTag, @Nonnull AlertDialog.Builder menuBuilder) {
        if (fragmentActivity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/DialogFragmentShower.<init> must not be null");
        }
        if (fragmentTag == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/DialogFragmentShower.<init> must not be null");
        }
        if (menuBuilder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/DialogFragmentShower.<init> must not be null");
        }
        this.fragmentActivity = fragmentActivity;
        this.fragmentTag = fragmentTag;
        this.menuBuilder = menuBuilder;
    }

    public void show() {
        this.show(false);
    }

    public void show(boolean addToBackStack) {
        if (addToBackStack) {
            Fragments.showDialog(new AlertDialogFragment(this.menuBuilder), this.fragmentTag, this.fragmentActivity.getSupportFragmentManager());
        } else {
            FragmentManager fm = this.fragmentActivity.getSupportFragmentManager();
            AlertDialogFragment fragment = new AlertDialogFragment(this.menuBuilder);
            fragment.show(fm, this.fragmentTag);
        }
    }

    public static final class AlertDialogFragment
    extends DialogFragment {
        @Nullable
        private final AlertDialog.Builder menuBuilder;

        private AlertDialogFragment(@Nonnull AlertDialog.Builder menuBuilder) {
            if (menuBuilder == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/DialogFragmentShower$AlertDialogFragment.<init> must not be null");
            }
            this.menuBuilder = menuBuilder;
        }

        public AlertDialogFragment() {
            this.menuBuilder = null;
        }

        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            if (this.menuBuilder == null) {
                this.dismiss();
            }
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            if (this.menuBuilder != null) {
                return this.menuBuilder.create();
            }
            return super.onCreateDialog(savedInstanceState);
        }
    }
}

