/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.util.Xml;
import android.view.InflateException;
import android.view.View;
import com.actionbarsherlock.R;
import com.actionbarsherlock.internal.view.menu.MenuItemImpl;
import com.actionbarsherlock.view.ActionProvider;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuItem;
import com.actionbarsherlock.view.SubMenu;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MenuInflater {
    private static final String LOG_TAG = "MenuInflater";
    private static final String XML_MENU = "menu";
    private static final String XML_GROUP = "group";
    private static final String XML_ITEM = "item";
    private static final int NO_ID = 0;
    private static final Class<?>[] ACTION_VIEW_CONSTRUCTOR_SIGNATURE = new Class[]{Context.class};
    private static final Class<?>[] ACTION_PROVIDER_CONSTRUCTOR_SIGNATURE = ACTION_VIEW_CONSTRUCTOR_SIGNATURE;
    private final Object[] mActionViewConstructorArguments;
    private final Object[] mActionProviderConstructorArguments;
    private Context mContext;
    private Object mRealOwner;

    public MenuInflater(Context context) {
        this.mContext = context;
        this.mRealOwner = context;
        this.mActionViewConstructorArguments = new Object[]{context};
        this.mActionProviderConstructorArguments = this.mActionViewConstructorArguments;
    }

    public MenuInflater(Context context, Object realOwner) {
        this.mContext = context;
        this.mRealOwner = realOwner;
        this.mActionViewConstructorArguments = new Object[]{context};
        this.mActionProviderConstructorArguments = this.mActionViewConstructorArguments;
    }

    public void inflate(int menuRes, Menu menu) {
        XmlResourceParser parser = null;
        try {
            parser = this.mContext.getResources().getLayout(menuRes);
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            this.parseMenu((XmlPullParser)parser, attrs, menu);
        }
        catch (XmlPullParserException e) {
            throw new InflateException("Error inflating menu XML", (Throwable)e);
        }
        catch (IOException e) {
            throw new InflateException("Error inflating menu XML", (Throwable)e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    private void parseMenu(XmlPullParser parser, AttributeSet attrs, Menu menu) throws XmlPullParserException, IOException {
        String tagName;
        MenuState menuState = new MenuState(menu);
        int eventType = parser.getEventType();
        boolean lookingForEndOfUnknownTag = false;
        String unknownTagName = null;
        do {
            if (eventType != 2) continue;
            tagName = parser.getName();
            if (tagName.equals(XML_MENU)) {
                eventType = parser.next();
                break;
            }
            throw new RuntimeException("Expecting menu, got " + tagName);
        } while ((eventType = parser.next()) != 1);
        boolean reachedEndOfMenu = false;
        while (!reachedEndOfMenu) {
            switch (eventType) {
                case 2: {
                    if (lookingForEndOfUnknownTag) break;
                    tagName = parser.getName();
                    if (tagName.equals(XML_GROUP)) {
                        menuState.readGroup(attrs);
                        break;
                    }
                    if (tagName.equals(XML_ITEM)) {
                        menuState.readItem(attrs);
                        break;
                    }
                    if (tagName.equals(XML_MENU)) {
                        SubMenu subMenu = menuState.addSubMenuItem();
                        this.parseMenu(parser, attrs, subMenu);
                        break;
                    }
                    lookingForEndOfUnknownTag = true;
                    unknownTagName = tagName;
                    break;
                }
                case 3: {
                    tagName = parser.getName();
                    if (lookingForEndOfUnknownTag && tagName.equals(unknownTagName)) {
                        lookingForEndOfUnknownTag = false;
                        unknownTagName = null;
                        break;
                    }
                    if (tagName.equals(XML_GROUP)) {
                        menuState.resetGroup();
                        break;
                    }
                    if (tagName.equals(XML_ITEM)) {
                        if (menuState.hasAddedItem()) break;
                        if (menuState.itemActionProvider != null && menuState.itemActionProvider.hasSubMenu()) {
                            menuState.addSubMenuItem();
                            break;
                        }
                        menuState.addItem();
                        break;
                    }
                    if (!tagName.equals(XML_MENU)) break;
                    reachedEndOfMenu = true;
                    break;
                }
                case 1: {
                    throw new RuntimeException("Unexpected end of document");
                }
            }
            eventType = parser.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MenuState {
        private Menu menu;
        private int groupId;
        private int groupCategory;
        private int groupOrder;
        private int groupCheckable;
        private boolean groupVisible;
        private boolean groupEnabled;
        private boolean itemAdded;
        private int itemId;
        private int itemCategoryOrder;
        private CharSequence itemTitle;
        private CharSequence itemTitleCondensed;
        private int itemIconResId;
        private char itemAlphabeticShortcut;
        private char itemNumericShortcut;
        private int itemCheckable;
        private boolean itemChecked;
        private boolean itemVisible;
        private boolean itemEnabled;
        private int itemShowAsAction;
        private int itemActionViewLayout;
        private String itemActionViewClassName;
        private String itemActionProviderClassName;
        private String itemListenerMethodName;
        private ActionProvider itemActionProvider;
        private static final int defaultGroupId = 0;
        private static final int defaultItemId = 0;
        private static final int defaultItemCategory = 0;
        private static final int defaultItemOrder = 0;
        private static final int defaultItemCheckable = 0;
        private static final boolean defaultItemChecked = false;
        private static final boolean defaultItemVisible = true;
        private static final boolean defaultItemEnabled = true;

        public MenuState(Menu menu) {
            this.menu = menu;
            this.resetGroup();
        }

        public void resetGroup() {
            this.groupId = 0;
            this.groupCategory = 0;
            this.groupOrder = 0;
            this.groupCheckable = 0;
            this.groupVisible = true;
            this.groupEnabled = true;
        }

        public void readGroup(AttributeSet attrs) {
            TypedArray a = MenuInflater.this.mContext.obtainStyledAttributes(attrs, R.styleable.SherlockMenuGroup);
            this.groupId = a.getResourceId(R.styleable.SherlockMenuGroup_android_id, 0);
            this.groupCategory = a.getInt(R.styleable.SherlockMenuGroup_android_menuCategory, 0);
            this.groupOrder = a.getInt(R.styleable.SherlockMenuGroup_android_orderInCategory, 0);
            this.groupCheckable = a.getInt(R.styleable.SherlockMenuGroup_android_checkableBehavior, 0);
            this.groupVisible = a.getBoolean(R.styleable.SherlockMenuGroup_android_visible, true);
            this.groupEnabled = a.getBoolean(R.styleable.SherlockMenuGroup_android_enabled, true);
            a.recycle();
        }

        public void readItem(AttributeSet attrs) {
            boolean hasActionProvider;
            TypedArray a = MenuInflater.this.mContext.obtainStyledAttributes(attrs, R.styleable.SherlockMenuItem);
            this.itemId = a.getResourceId(R.styleable.SherlockMenuItem_android_id, 0);
            int category = a.getInt(R.styleable.SherlockMenuItem_android_menuCategory, this.groupCategory);
            int order = a.getInt(R.styleable.SherlockMenuItem_android_orderInCategory, this.groupOrder);
            this.itemCategoryOrder = category & 0xFFFF0000 | order & 0xFFFF;
            this.itemTitle = a.getText(R.styleable.SherlockMenuItem_android_title);
            this.itemTitleCondensed = a.getText(R.styleable.SherlockMenuItem_android_titleCondensed);
            this.itemIconResId = a.getResourceId(R.styleable.SherlockMenuItem_android_icon, 0);
            this.itemAlphabeticShortcut = this.getShortcut(a.getString(R.styleable.SherlockMenuItem_android_alphabeticShortcut));
            this.itemNumericShortcut = this.getShortcut(a.getString(R.styleable.SherlockMenuItem_android_numericShortcut));
            this.itemCheckable = a.hasValue(R.styleable.SherlockMenuItem_android_checkable) ? (a.getBoolean(R.styleable.SherlockMenuItem_android_checkable, false) ? 1 : 0) : this.groupCheckable;
            this.itemChecked = a.getBoolean(R.styleable.SherlockMenuItem_android_checked, false);
            this.itemVisible = a.getBoolean(R.styleable.SherlockMenuItem_android_visible, this.groupVisible);
            this.itemEnabled = a.getBoolean(R.styleable.SherlockMenuItem_android_enabled, this.groupEnabled);
            TypedValue value = new TypedValue();
            a.getValue(R.styleable.SherlockMenuItem_android_showAsAction, value);
            this.itemShowAsAction = value.type == 17 ? value.data : -1;
            this.itemListenerMethodName = a.getString(R.styleable.SherlockMenuItem_android_onClick);
            this.itemActionViewLayout = a.getResourceId(R.styleable.SherlockMenuItem_android_actionLayout, 0);
            value = new TypedValue();
            a.getValue(R.styleable.SherlockMenuItem_android_actionViewClass, value);
            this.itemActionViewClassName = value.type == 3 ? value.string.toString() : null;
            value = new TypedValue();
            a.getValue(R.styleable.SherlockMenuItem_android_actionProviderClass, value);
            this.itemActionProviderClassName = value.type == 3 ? value.string.toString() : null;
            boolean bl = hasActionProvider = this.itemActionProviderClassName != null;
            if (hasActionProvider && this.itemActionViewLayout == 0 && this.itemActionViewClassName == null) {
                this.itemActionProvider = (ActionProvider)this.newInstance(this.itemActionProviderClassName, ACTION_PROVIDER_CONSTRUCTOR_SIGNATURE, MenuInflater.this.mActionProviderConstructorArguments);
            } else {
                if (hasActionProvider) {
                    Log.w((String)MenuInflater.LOG_TAG, (String)"Ignoring attribute 'actionProviderClass'. Action view already specified.");
                }
                this.itemActionProvider = null;
            }
            a.recycle();
            this.itemAdded = false;
        }

        private char getShortcut(String shortcutString) {
            if (shortcutString == null) {
                return '\u0000';
            }
            return shortcutString.charAt(0);
        }

        private void setItem(MenuItem item) {
            item.setChecked(this.itemChecked).setVisible(this.itemVisible).setEnabled(this.itemEnabled).setCheckable(this.itemCheckable >= 1).setTitleCondensed(this.itemTitleCondensed).setIcon(this.itemIconResId).setAlphabeticShortcut(this.itemAlphabeticShortcut).setNumericShortcut(this.itemNumericShortcut);
            if (this.itemShowAsAction >= 0) {
                item.setShowAsAction(this.itemShowAsAction);
            }
            if (this.itemListenerMethodName != null) {
                if (MenuInflater.this.mContext.isRestricted()) {
                    throw new IllegalStateException("The android:onClick attribute cannot be used within a restricted context");
                }
                item.setOnMenuItemClickListener(new InflatedOnMenuItemClickListener(MenuInflater.this.mRealOwner, this.itemListenerMethodName));
            }
            if (this.itemCheckable >= 2) {
                if (item instanceof MenuItemImpl) {
                    MenuItemImpl impl = (MenuItemImpl)item;
                    impl.setExclusiveCheckable(true);
                } else {
                    this.menu.setGroupCheckable(this.groupId, true, true);
                }
            }
            boolean actionViewSpecified = false;
            if (this.itemActionViewClassName != null) {
                View actionView = (View)this.newInstance(this.itemActionViewClassName, ACTION_VIEW_CONSTRUCTOR_SIGNATURE, MenuInflater.this.mActionViewConstructorArguments);
                item.setActionView(actionView);
                actionViewSpecified = true;
            }
            if (this.itemActionViewLayout > 0) {
                if (!actionViewSpecified) {
                    item.setActionView(this.itemActionViewLayout);
                    actionViewSpecified = true;
                } else {
                    Log.w((String)MenuInflater.LOG_TAG, (String)"Ignoring attribute 'itemActionViewLayout'. Action view already specified.");
                }
            }
            if (this.itemActionProvider != null) {
                item.setActionProvider(this.itemActionProvider);
            }
        }

        public void addItem() {
            this.itemAdded = true;
            this.setItem(this.menu.add(this.groupId, this.itemId, this.itemCategoryOrder, this.itemTitle));
        }

        public SubMenu addSubMenuItem() {
            this.itemAdded = true;
            SubMenu subMenu = this.menu.addSubMenu(this.groupId, this.itemId, this.itemCategoryOrder, this.itemTitle);
            this.setItem(subMenu.getItem());
            return subMenu;
        }

        public boolean hasAddedItem() {
            return this.itemAdded;
        }

        private <T> T newInstance(String className, Class<?>[] constructorSignature, Object[] arguments) {
            try {
                Class<?> clazz = MenuInflater.this.mContext.getClassLoader().loadClass(className);
                Constructor<?> constructor = clazz.getConstructor(constructorSignature);
                return (T)constructor.newInstance(arguments);
            }
            catch (Exception e) {
                Log.w((String)MenuInflater.LOG_TAG, (String)("Cannot instantiate class: " + className), (Throwable)e);
                return null;
            }
        }
    }

    private static class InflatedOnMenuItemClickListener
    implements MenuItem.OnMenuItemClickListener {
        private static final Class<?>[] PARAM_TYPES = new Class[]{MenuItem.class};
        private Object mRealOwner;
        private Method mMethod;

        public InflatedOnMenuItemClickListener(Object realOwner, String methodName) {
            this.mRealOwner = realOwner;
            Class<?> c = realOwner.getClass();
            try {
                this.mMethod = c.getMethod(methodName, PARAM_TYPES);
            }
            catch (Exception e) {
                InflateException ex = new InflateException("Couldn't resolve menu item onClick handler " + methodName + " in class " + c.getName());
                ex.initCause((Throwable)e);
                throw ex;
            }
        }

        public boolean onMenuItemClick(MenuItem item) {
            try {
                if (this.mMethod.getReturnType() == Boolean.TYPE) {
                    return (Boolean)this.mMethod.invoke(this.mRealOwner, item);
                }
                this.mMethod.invoke(this.mRealOwner, item);
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

