/*
 * Copyright 2013 serso aka se.solovyev
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Contact details
 *
 * Email: se.solovyev@gmail.com
 * Site:  http://se.solovyev.org
 */

package org.solovyev.android.view;

import org.solovyev.common.text.Formatter;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;

/**
 * User: serso
 * Date: 8/10/12
 * Time: 1:55 AM
 */
public class ListRange<T> implements Picker.Range<T> {

	@Nonnull
	private List<T> elements;

	private int startPosition;

	@Nullable
	private Formatter<T> formatter;

	public ListRange(@Nonnull List<T> elements, @Nullable T selected) {
		this.elements = elements;
		this.startPosition = elements.indexOf(selected);
		if (this.startPosition < 0) {
			this.startPosition = 0;
		}
		this.formatter = null;
	}

	public ListRange(@Nonnull List<T> elements, @Nullable T selected, @Nullable Formatter<T> formatter) {
		this(elements, selected);
		this.formatter = formatter;
	}

	@Override
	public int getStartPosition() {
		return this.startPosition;
	}

	@Override
	public int getCount() {
		return this.elements.size();
	}

	@Nonnull
	@Override
	public String getStringValueAt(int position) {
		final T value = getValueAt(position);
		return formatter == null ? value.toString() : formatter.formatValue(value);
	}

	@Nonnull
	@Override
	public T getValueAt(int position) {
		return this.elements.get(position);
	}
}
