/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.network.NetworkData;
import org.solovyev.android.network.NetworkDataImpl;
import org.solovyev.android.network.NetworkStateListener;
import org.solovyev.android.network.NetworkStateService;
import org.solovyev.common.listeners.JListeners;
import org.solovyev.common.listeners.Listeners;

public final class NetworkStateServiceImpl
implements NetworkStateService {
    private static final boolean DEBUG = false;
    @Nullable
    private Context context;
    @Nonnull
    private final JListeners<NetworkStateListener> listeners = Listeners.newHardRefListeners();
    @Nonnull
    private NetworkData networkData = NetworkDataImpl.newUnknownNetworkData();
    @Nonnull
    private BroadcastReceiver receiver = new ConnectivityBroadcastReceiver();

    public synchronized void startListening(@Nonnull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/network/NetworkStateServiceImpl.startListening must not be null");
        }
        this.context = context.getApplicationContext();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver(this.receiver, filter);
    }

    public boolean addListener(@Nonnull NetworkStateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/network/NetworkStateServiceImpl.addListener must not be null");
        }
        return this.listeners.addListener((Object)listener);
    }

    public boolean removeListener(@Nonnull NetworkStateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/network/NetworkStateServiceImpl.removeListener must not be null");
        }
        return this.listeners.removeListener((Object)listener);
    }

    public synchronized void stopListening() {
        if (this.context != null) {
            this.context.unregisterReceiver(this.receiver);
        }
        this.context = null;
        this.networkData = NetworkDataImpl.newUnknownNetworkData();
    }

    @Nonnull
    public NetworkData getNetworkData() {
        NetworkData networkData = this.networkData;
        if (networkData == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/network/NetworkStateServiceImpl.getNetworkData must not return null");
        }
        return networkData;
    }

    private class ConnectivityBroadcastReceiver
    extends BroadcastReceiver {
        private ConnectivityBroadcastReceiver() {
        }

        public void onReceive(@Nonnull Context context, @Nonnull Intent intent) {
            if (context == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/network/NetworkStateServiceImpl$ConnectivityBroadcastReceiver.onReceive must not be null");
            }
            if (intent == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/network/NetworkStateServiceImpl$ConnectivityBroadcastReceiver.onReceive must not be null");
            }
            String action = intent.getAction();
            if (!action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                return;
            }
            NetworkData localNetworkData = NetworkDataImpl.fromIntent(intent);
            NetworkStateServiceImpl.this.networkData = localNetworkData;
            for (NetworkStateListener localListener : NetworkStateServiceImpl.this.listeners.getListeners()) {
                localListener.onNetworkEvent(localNetworkData);
            }
        }
    }
}

