/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.network;

import android.content.Intent;
import android.net.NetworkInfo;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.network.NetworkData;
import org.solovyev.android.network.NetworkState;

final class NetworkDataImpl
implements NetworkData {
    @Nonnull
    private NetworkState state = NetworkState.UNKNOWN;
    @Nullable
    private String reason;
    private boolean failover = false;
    @Nullable
    private NetworkInfo networkInfo;
    @Nullable
    private NetworkInfo otherNetworkInfo;

    private NetworkDataImpl() {
    }

    @Nonnull
    static NetworkData newUnknownNetworkData() {
        NetworkDataImpl networkDataImpl = new NetworkDataImpl();
        if (networkDataImpl == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/network/NetworkDataImpl.newUnknownNetworkData must not return null");
        }
        return networkDataImpl;
    }

    @Nonnull
    static NetworkData fromIntent(@Nonnull Intent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/network/NetworkDataImpl.fromIntent must not be null");
        }
        assert ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction()));
        NetworkDataImpl result = new NetworkDataImpl();
        boolean connected = !intent.getBooleanExtra("noConnectivity", false);
        result.state = connected ? NetworkState.CONNECTED : NetworkState.NOT_CONNECTED;
        result.networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
        result.otherNetworkInfo = (NetworkInfo)intent.getParcelableExtra("otherNetwork");
        result.reason = intent.getStringExtra("reason");
        result.failover = intent.getBooleanExtra("isFailover", false);
        NetworkDataImpl networkDataImpl = result;
        if (networkDataImpl == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/network/NetworkDataImpl.fromIntent must not return null");
        }
        return networkDataImpl;
    }

    @Nonnull
    public NetworkState getState() {
        NetworkState networkState = this.state;
        if (networkState == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/network/NetworkDataImpl.getState must not return null");
        }
        return networkState;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    public boolean isFailover() {
        return this.failover;
    }

    @Nullable
    public NetworkInfo getNetworkInfo() {
        return this.networkInfo;
    }

    @Nullable
    public NetworkInfo getOtherNetworkInfo() {
        return this.otherNetworkInfo;
    }

    public String toString() {
        return "NetworkDataImpl{state=" + (Object)((Object)this.state) + ", reason='" + this.reason + '\'' + ", failover=" + this.failover + ", networkInfo=" + this.networkInfo + ", otherNetworkInfo=" + this.otherNetworkInfo + '}';
    }
}

