/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.smooks;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.milyn.Smooks;
import org.milyn.container.ExecutionContext;
import org.milyn.event.ExecutionEventListener;
import org.milyn.event.report.HtmlReportGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.mule.util.MiscUtil;

public class SmooksUtil {
    private static final Logger logger = LoggerFactory.getLogger(SmooksUtil.class);

    private SmooksUtil() {
        throw new UnsupportedOperationException("Not allowed to create an instance of this class");
    }

    public static void runSmooksTransformer(Source source, Result result, String smookesConfig, String report) {
        try (Smooks smooks = null;){
            smooks = new Smooks(smookesConfig);
            ExecutionContext executionContext = smooks.createExecutionContext();
            if (report != null) {
                executionContext.setEventListener((ExecutionEventListener)new HtmlReportGenerator(report));
            }
            smooks.filterSource(executionContext, source, new Result[]{result});
        }
    }

    public static void runSmooksTransformer(Source source, Result result, String smookesConfig) {
        SmooksUtil.runSmooksTransformer(source, result, smookesConfig, "target/smooks-report/report.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runSmooksTransformer(String source, String smookesConfig) {
        StringWriter writer = new StringWriter();
        try {
            SmooksUtil.runSmooksTransformer(new StreamSource(new StringReader(source)), new StreamResult(writer), smookesConfig);
            String result = writer.toString();
            result = MiscUtil.removeLeadingNewLines(result);
            result = MiscUtil.removeTrailingNewLines(result);
            logger.debug("Result from smooks transformation [{}]", (Object)result);
            String string = result;
            return string;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {}
        }
    }
}

