/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.sftp;

import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.notification.ServerNotification;
import org.mule.transport.sftp.notification.SftpTransportNotification;
import org.mule.transport.sftp.notification.SftpTransportNotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.mule.api.log.EventLogMessage;
import org.soitoolkit.commons.mule.api.log.EventLogger;
import org.soitoolkit.commons.mule.log.EventLoggerFactory;

public class SftpTransportNotificationListenerImpl
implements SftpTransportNotificationListener,
MuleContextAware {
    private static final Logger logger = LoggerFactory.getLogger(SftpTransportNotificationListenerImpl.class);
    private EventLogger eventLogger;
    private MuleContext muleContext = null;

    public SftpTransportNotificationListenerImpl() {
        logger.debug("SftpTransportNotificationListenerImpl Created");
    }

    public void setMuleContext(MuleContext muleContext) {
        logger.debug("MuleContext injected");
        this.muleContext = muleContext;
        this.eventLogger = EventLoggerFactory.getEventLogger(muleContext);
    }

    public void onNotification(ServerNotification notification) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        SftpTransportNotification sftpNotification = null;
        if (!(notification instanceof SftpTransportNotification)) {
            logger.debug("Received an unknown type of notification: {}", (Object)notification.getClass().getName());
            return;
        }
        sftpNotification = (SftpTransportNotification)notification;
        MuleMessage message = (MuleMessage)notification.getSource();
        String action = notification.getActionName();
        String info = sftpNotification.getInfo();
        long size = sftpNotification.getSize();
        if (action == null) {
            action = "";
        }
        if (info == null) {
            info = "";
        }
        if (info.length() != 0) {
            if (size > 0L) {
                info = info + ", size = " + size;
            }
            action = action + " (" + info + ")";
        }
        EventLogMessage elm = new EventLogMessage();
        elm.setMuleMessage(message);
        elm.setLogMessage(action);
        this.eventLogger.logInfoEvent(elm);
    }
}

