/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.soap;

import javax.net.ssl.TrustManager;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.transport.http.HTTPConduit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.mule.soap.FakeTrustManager;

public class SoapUtil {
    private static Logger log = LoggerFactory.getLogger(SoapUtil.class);

    private SoapUtil() {
        throw new UnsupportedOperationException("Not allowed to create an instance of this class");
    }

    public static void disableTlsServerCertificateCheck(Client client) {
        if (!(client.getConduit() instanceof HTTPConduit)) {
            log.warn("Conduit not of type HTTPConduit (" + client.getConduit().getClass().getName() + ") , skip disabling server certification validation.");
            return;
        }
        log.warn("Disables server certification validation for: " + client.getEndpoint().getEndpointInfo().getAddress());
        HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
        TLSClientParameters tlsParams = new TLSClientParameters();
        TrustManager[] trustAllCerts = new TrustManager[]{new FakeTrustManager()};
        tlsParams.setTrustManagers(trustAllCerts);
        tlsParams.setDisableCNCheck(true);
        httpConduit.setTlsClientParameters(tlsParams);
    }
}

