/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.log;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.MuleContextAware;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.ExceptionHelper;
import org.mule.module.xml.stax.ReversibleXMLStreamReader;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsMessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.soitoolkit.commons.logentry.schema.v1.LogEntryType;
import org.soitoolkit.commons.logentry.schema.v1.LogEvent;
import org.soitoolkit.commons.logentry.schema.v1.LogLevelType;
import org.soitoolkit.commons.logentry.schema.v1.LogMessageExceptionType;
import org.soitoolkit.commons.logentry.schema.v1.LogMessageType;
import org.soitoolkit.commons.logentry.schema.v1.LogMetadataInfoType;
import org.soitoolkit.commons.logentry.schema.v1.LogRuntimeInfoType;
import org.soitoolkit.commons.mule.api.log.EventLogMessage;
import org.soitoolkit.commons.mule.api.log.EventLogger;
import org.soitoolkit.commons.mule.jaxb.JaxbObjectToXmlTransformer;
import org.soitoolkit.commons.mule.jaxb.JaxbUtil;
import org.soitoolkit.commons.mule.util.MuleUtil;
import org.soitoolkit.commons.mule.util.XmlUtil;

public class DefaultEventLogger
implements EventLogger,
MuleContextAware {
    private static final String CAUSE_EXCEPTION_HEADER = "CauseException";
    private static final Logger messageLogger = LoggerFactory.getLogger((String)"org.soitoolkit.commons.mule.messageLogger");
    private static final Logger log = LoggerFactory.getLogger(DefaultEventLogger.class);
    private static final JaxbUtil JAXB_UTIL = new JaxbUtil(LogEvent.class);
    private static final String MSG_ID = "soi-toolkit.log";
    private static final String LOG_EVENT_INFO = "logEvent-info";
    private static final String LOG_EVENT_ERROR = "logEvent-error";
    private static final String LOG_STRING = "soi-toolkit.log\n** {}.start ***********************************************************\nIntegrationScenarioId={}\nContractId={}\nLogMessage={}\nServiceImpl={}\nHost={} ({})\nComponentId={}\nEndpoint={}\nMessageId={}\nBusinessCorrelationId={}\nBusinessContextId={}\nExtraInfo={}\nPayload={}{}\n** {}.end *************************************************************";
    private static InetAddress HOST = null;
    private static String HOST_NAME = "UNKNOWN";
    private static String HOST_IP = "UNKNOWN";
    private static String PROCESS_ID = "UNKNOWN";
    private String serverId = null;
    private JaxbObjectToXmlTransformer jaxbToXml = null;
    private JAXBContext jaxbContext = null;
    private boolean doLogToJms = true;
    private String jmsInfoEventQueue = "SOITOOLKIT.LOG.INFO";
    private String jmsErrorEventQueue = "SOITOOLKIT.LOG.ERROR";
    private MuleContext muleContext = null;

    public DefaultEventLogger() {
        log.debug("constructor");
    }

    public void setMuleContext(MuleContext muleContext) {
        log.debug("MuleContext injected");
        this.muleContext = muleContext;
    }

    public void setJaxbToXml(JaxbObjectToXmlTransformer jaxbToXml) {
        this.jaxbToXml = jaxbToXml;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public void setDoLogToJms(boolean doLogToJms) {
        log.debug("setting doLogToJms: {}", (Object)doLogToJms);
        this.doLogToJms = doLogToJms;
    }

    public void setJmsInfoEventQueue(String jmsInfoEventQueue) {
        log.debug("setting jmsInfoEventQueue: {}", (Object)jmsInfoEventQueue);
        this.jmsInfoEventQueue = jmsInfoEventQueue;
    }

    public void setJmsErrorEventQueue(String jmsErrorEventQueue) {
        log.debug("setting jmsErrorEventQueue: {}", (Object)jmsErrorEventQueue);
        this.jmsErrorEventQueue = jmsErrorEventQueue;
    }

    @Override
    public void logErrorEvent(LogLevelType logLevel, Throwable error, EventLogMessage elm) {
        if (logLevel == null) {
            logLevel = LogLevelType.ERROR;
        }
        this.logErrorEvent(logLevel, error, elm.getMuleMessage(), elm.getIntegrationScenario(), elm.getContractId(), elm.getBusinessContextId(), elm.getExtraInfo());
    }

    @Override
    public void logErrorEvent(Throwable error, EventLogMessage elm) {
        this.logErrorEvent(LogLevelType.ERROR, error, elm);
    }

    @Override
    public void logInfoEvent(LogLevelType logLevel, EventLogMessage elm) {
        this.logInfoEvent(logLevel, elm.getMuleMessage(), elm.getLogMessage(), elm.getIntegrationScenario(), elm.getContractId(), elm.getBusinessContextId(), elm.getExtraInfo());
    }

    @Override
    public void logInfoEvent(EventLogMessage elm) {
        this.logInfoEvent(LogLevelType.INFO, elm);
    }

    protected void logInfoEvent(LogLevelType logLevel, MuleMessage message, String logMessage, String integrationScenario, String contractId, Map<String, String> businessContextId, Map<String, String> extraInfo) {
        if (messageLogger.isInfoEnabled()) {
            LogEvent logEvent = this.createLogEntry(logLevel, message, logMessage, integrationScenario, contractId, businessContextId, extraInfo, message.getPayload(), null);
            String logMsg = this.formatLogMessage(LOG_EVENT_INFO, logEvent);
            messageLogger.info(logMsg);
            String xmlString = JAXB_UTIL.marshal(logEvent);
            this.dispatchInfoEvent(xmlString);
        }
    }

    protected void logErrorEvent(LogLevelType logLevel, Throwable error, MuleMessage message, String integrationScenario, String contractId, Map<String, String> businessContextId, Map<String, String> extraInfo) {
        LogEvent logEvent = this.createLogEntry(logLevel, message, error.toString(), integrationScenario, contractId, businessContextId, extraInfo, message.getPayload(), error);
        String logMsg = this.formatLogMessage(LOG_EVENT_ERROR, logEvent);
        messageLogger.error(logMsg);
        String xmlString = JAXB_UTIL.marshal(logEvent);
        this.dispatchErrorEvent(xmlString);
    }

    @Override
    public void logErrorEvent(Throwable error, Object payload, EventLogMessage elm) {
        this.logErrorEvent(error, payload, elm.getBusinessContextId(), elm.getExtraInfo());
    }

    protected LogEvent createLogEntry(LogLevelType logLevel, MuleMessage message, String logMessage, String argIntegrationScenario, String argContractId, Map<String, String> businessContextId, Map<String, String> extraInfo, Object payload, Throwable exception) {
        String serviceImplementation = "";
        MuleEventContext event = RequestContext.getEventContext();
        if (event != null) {
            serviceImplementation = MuleUtil.getServiceName(event);
        }
        String endpoint = this.getEndpoint(message, event);
        String messageId = "";
        String integrationScenarioId = "";
        String contractId = "";
        String businessCorrelationId = "";
        String propertyBusinessContextId = null;
        if (message != null) {
            if (log.isDebugEnabled()) {
                Set names = message.getPropertyNames(PropertyScope.INBOUND);
                for (Object object : names) {
                    Object value = message.getInboundProperty(object.toString());
                    log.debug(object + " = " + value + " (" + object.getClass().getName() + ")");
                }
            }
            messageId = message.getUniqueId();
            contractId = (String)message.getInboundProperty("soitoolkit_contractId", (Object)"");
            businessCorrelationId = (String)message.getSessionProperty("soitoolkit_correlationId", (Object)"");
            if ("".equals(businessCorrelationId)) {
                businessCorrelationId = (String)message.getInboundProperty("soitoolkit_correlationId", (Object)"");
            }
            integrationScenarioId = (String)message.getInboundProperty("soitoolkit_integrationScenario", (Object)"");
            propertyBusinessContextId = (String)message.getInboundProperty("soitoolkit_businessContextId", null);
            if (argContractId != null && argContractId.length() > 0) {
                contractId = argContractId;
            }
            if (argIntegrationScenario != null && argIntegrationScenario.length() > 0) {
                integrationScenarioId = argIntegrationScenario;
            }
        }
        String componentId = this.getServerId();
        String payloadASstring = messageLogger.isDebugEnabled() ? this.getPayloadAsString(payload) : "";
        LogRuntimeInfoType lri = new LogRuntimeInfoType();
        lri.setTimestamp(XmlUtil.convertDateToXmlDate(null));
        lri.setHostName(HOST_NAME);
        lri.setHostIp(HOST_IP);
        lri.setProcessId(PROCESS_ID);
        lri.setThreadId(Thread.currentThread().getName());
        lri.setComponentId(componentId);
        lri.setMessageId(messageId);
        lri.setBusinessCorrelationId(businessCorrelationId);
        if (businessContextId != null) {
            Set<Map.Entry<String, String>> entries = businessContextId.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                LogRuntimeInfoType.BusinessContextId bxid = new LogRuntimeInfoType.BusinessContextId();
                bxid.setName(entry.getKey());
                bxid.setValue(entry.getValue());
                lri.getBusinessContextId().add(bxid);
            }
        }
        if (propertyBusinessContextId != null) {
            String[] propertyArr;
            for (String property : propertyArr = propertyBusinessContextId.split(",")) {
                String[] nameValueArr = property.split("=");
                String name = nameValueArr[0];
                String value = nameValueArr.length > 1 ? nameValueArr[1] : "";
                LogRuntimeInfoType.BusinessContextId bxid = new LogRuntimeInfoType.BusinessContextId();
                bxid.setName(name);
                bxid.setValue(value);
                lri.getBusinessContextId().add(bxid);
            }
        }
        LogMetadataInfoType lmi = new LogMetadataInfoType();
        lmi.setLoggerName(messageLogger.getName());
        lmi.setIntegrationScenarioId(integrationScenarioId);
        lmi.setContractId(contractId);
        lmi.setServiceImplementation(serviceImplementation);
        lmi.setEndpoint(endpoint);
        LogMessageType lm = new LogMessageType();
        lm.setLevel(logLevel);
        lm.setMessage(logMessage);
        if (exception != null) {
            exception = DefaultMuleConfiguration.verboseExceptions ? exception : ExceptionHelper.summarise((Throwable)exception, (int)5);
            LogMessageExceptionType lme = new LogMessageExceptionType();
            lme.setExceptionClass(exception.getClass().getName());
            lme.setExceptionMessage(exception.getMessage());
            StackTraceElement[] stArr = exception.getStackTrace();
            ArrayList<String> stList = new ArrayList<String>();
            for (int i = 0; i < stArr.length; ++i) {
                stList.add(stArr[i].toString());
            }
            if (exception.getCause() != null) {
                Throwable ce = exception.getCause();
                ce = DefaultMuleConfiguration.verboseExceptions ? ce : ExceptionHelper.summarise((Throwable)ce, (int)5);
                stList.add("CauseException: " + ce.getMessage());
                StackTraceElement[] ceStArr = ce.getStackTrace();
                for (int i = 0; i < ceStArr.length; ++i) {
                    stList.add(ceStArr[i].toString());
                }
            }
            if (!DefaultMuleConfiguration.verboseExceptions) {
                stList.add("*** set debug level logging or '-Dmule.verbose.exceptions=true' for full stacktrace ***");
            }
            lme.getStackTrace().addAll(stList);
            lm.setException(lme);
        }
        LogEntryType logEntry = new LogEntryType();
        logEntry.setMetadataInfo(lmi);
        logEntry.setRuntimeInfo(lri);
        logEntry.setMessageInfo(lm);
        logEntry.setPayload(payloadASstring);
        if (extraInfo != null) {
            Set<Map.Entry<String, String>> entries = extraInfo.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                LogEntryType.ExtraInfo ei = new LogEntryType.ExtraInfo();
                ei.setName(entry.getKey());
                ei.setValue(entry.getValue());
                logEntry.getExtraInfo().add(ei);
            }
        }
        LogEvent logEvent = new LogEvent();
        logEvent.setLogEntry(logEntry);
        return logEvent;
    }

    private void logErrorEvent(Throwable error, Object payload, Map<String, String> businessContextId, Map<String, String> extraInfo) {
        LogEvent logEvent = this.createLogEntry(LogLevelType.ERROR, null, error.toString(), null, null, businessContextId, extraInfo, payload, error);
        String logMsg = this.formatLogMessage(LOG_EVENT_ERROR, logEvent);
        messageLogger.error(logMsg);
        String xmlString = JAXB_UTIL.marshal(logEvent);
        this.dispatchErrorEvent(xmlString);
    }

    protected String getEndpoint(MuleMessage message, MuleEventContext event) {
        try {
            if (message != null) {
                String outEp = (String)message.getOutboundProperty("MULE_ENDPOINT");
                if (outEp != null) {
                    String httpMethod;
                    if (outEp.startsWith("http") && (httpMethod = (String)message.getOutboundProperty("http.method")) != null) {
                        outEp = outEp + " (" + httpMethod + ")";
                    }
                    return outEp;
                }
                String inEp = (String)message.getInboundProperty("MULE_ENDPOINT");
                if (inEp != null) {
                    String httpMethod;
                    if (inEp.startsWith("http") && (httpMethod = (String)message.getInboundProperty("http.method")) != null) {
                        inEp = inEp + " (" + httpMethod + ")";
                    }
                    return inEp;
                }
            }
            if (event != null) {
                String ep;
                URI endpointURI = event.getEndpointURI();
                String string = ep = endpointURI == null ? "" : endpointURI.toString();
                if (ep.startsWith("http")) {
                    String httpMethod = (String)message.getInboundProperty("http.method");
                    String httpRequest = (String)message.getInboundProperty("http.request");
                    if (httpMethod != null) {
                        ep = ep + " (" + httpMethod + " on " + httpRequest + ")";
                    }
                }
                return ep;
            }
            return "";
        }
        catch (Throwable ex) {
            return "GET-ENDPOINT ERROR: " + ex.getMessage();
        }
    }

    protected String formatLogMessage(String logEventName, LogEvent logEvent) {
        LogMessageType messageInfo = logEvent.getLogEntry().getMessageInfo();
        LogMetadataInfoType metadataInfo = logEvent.getLogEntry().getMetadataInfo();
        LogRuntimeInfoType runtimeInfo = logEvent.getLogEntry().getRuntimeInfo();
        String integrationScenarioId = metadataInfo.getIntegrationScenarioId();
        String contractId = metadataInfo.getContractId();
        String logMessage = messageInfo.getMessage();
        String serviceImplementation = metadataInfo.getServiceImplementation();
        String componentId = runtimeInfo.getComponentId();
        String endpoint = metadataInfo.getEndpoint();
        String messageId = runtimeInfo.getMessageId();
        String businessCorrelationId = runtimeInfo.getBusinessCorrelationId();
        String payload = logEvent.getLogEntry().getPayload();
        String businessContextIdString = this.businessContextIdToString(runtimeInfo.getBusinessContextId());
        String extraInfoString = this.extraInfoToString(logEvent.getLogEntry().getExtraInfo());
        StringBuffer stackTrace = new StringBuffer();
        LogMessageExceptionType lmeException = logEvent.getLogEntry().getMessageInfo().getException();
        if (lmeException != null) {
            String ex = lmeException.getExceptionClass();
            String msg = lmeException.getExceptionMessage();
            List st = lmeException.getStackTrace();
            stackTrace.append('\n').append("Stacktrace=").append(ex).append(": ").append(msg);
            for (String stLine : st) {
                if (stLine.startsWith(CAUSE_EXCEPTION_HEADER)) {
                    stackTrace.append("\n\n").append(stLine);
                    continue;
                }
                stackTrace.append("\n\t at ").append(stLine);
            }
        }
        return MessageFormatter.arrayFormat((String)LOG_STRING, (Object[])new String[]{logEventName, integrationScenarioId, contractId, logMessage, serviceImplementation, HOST_NAME, HOST_IP, componentId, endpoint, messageId, businessCorrelationId, businessContextIdString, extraInfoString, payload, stackTrace.toString(), logEventName}).getMessage();
    }

    protected void dispatchInfoEvent(String msg) {
        this.dispatchEvent(this.jmsInfoEventQueue, msg);
    }

    protected void dispatchErrorEvent(String msg) {
        this.dispatchEvent(this.jmsErrorEventQueue, msg);
    }

    protected boolean getDoLogToJms(String queue, String msg) {
        return this.doLogToJms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(String queue, String msg) {
        if (!this.getDoLogToJms(queue, msg)) {
            log.debug("logging to JMS is OFF, queue: {}", (Object)queue);
            return;
        }
        log.debug("logging to JMS is ON, queue: {}", (Object)queue);
        try {
            Session s = null;
            try {
                s = this.getSession();
                this.sendOneTextMessage(s, queue, msg);
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    private Session getSession() throws JMSException {
        JmsConnector jmsConn = (JmsConnector)MuleUtil.getSpringBean(this.muleContext, "soitoolkit-jms-connector");
        Connection c = jmsConn.getConnection();
        Session s = c.createSession(false, 1);
        return s;
    }

    private void sendOneTextMessage(Session session, String queueName, String message) {
        MessageProducer publisher = null;
        try {
            publisher = session.createProducer((Destination)session.createQueue(queueName));
            TextMessage textMessage = session.createTextMessage(message);
            publisher.send((Message)textMessage);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (publisher != null) {
                    publisher.close();
                }
            }
            catch (JMSException e) {}
        }
    }

    private String businessContextIdToString(List<LogRuntimeInfoType.BusinessContextId> businessContextIds) {
        if (businessContextIds == null) {
            return "";
        }
        StringBuffer businessContextIdString = new StringBuffer();
        for (LogRuntimeInfoType.BusinessContextId bci : businessContextIds) {
            businessContextIdString.append("\n-").append(bci.getName()).append("=").append(bci.getValue());
        }
        return businessContextIdString.toString();
    }

    private String extraInfoToString(List<LogEntryType.ExtraInfo> extraInfo) {
        if (extraInfo == null) {
            return "";
        }
        StringBuffer extraInfoString = new StringBuffer();
        for (LogEntryType.ExtraInfo ei : extraInfo) {
            extraInfoString.append("\n-").append(ei.getName()).append("=").append(ei.getValue());
        }
        return extraInfoString.toString();
    }

    private String getServerId() {
        if (this.serverId != null) {
            return this.serverId;
        }
        if (this.muleContext == null) {
            return "UNKNOWN.MULE_CONTEXT";
        }
        MuleConfiguration mConf = this.muleContext.getConfiguration();
        if (mConf == null) {
            return "UNKNOWN.MULE_CONFIGURATION";
        }
        this.serverId = mConf.getId();
        return this.serverId;
    }

    private String getPayloadAsString(Object payload) {
        String content = null;
        if (payload instanceof Object[]) {
            Object[] arr = (Object[])payload;
            int i = 0;
            for (Object object : arr) {
                String arrContent = "[" + i++ + "]: " + this.getContentAsString(object);
                content = i == 1 ? arrContent : content + "\n" + arrContent;
            }
        } else {
            content = this.getContentAsString(payload);
        }
        return content;
    }

    private String getContentAsString(Object payload) {
        String content = null;
        if (payload == null) {
            return null;
        }
        content = payload instanceof byte[] ? this.getByteArrayContentAsString(payload) : (payload instanceof ReversibleXMLStreamReader ? XmlUtil.convertReversibleXMLStreamReaderToString((ReversibleXMLStreamReader)payload, "UTF-8") : (payload instanceof Message ? this.convertJmsMessageToString(payload, "UTF-8") : (this.isJabxObject(payload) ? this.getJaxbContentAsString(payload, "UTF-8") : payload.toString())));
        return content;
    }

    private String convertJmsMessageToString(Object payload, String outputEncoding) {
        try {
            return JmsMessageUtils.toObject((Message)((Message)payload), null, (String)outputEncoding).toString();
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getByteArrayContentAsString(Object payload) {
        StringBuffer byteArray = new StringBuffer();
        byte[] bytes = (byte[])payload;
        for (int i = 0; i < bytes.length; ++i) {
            byteArray.append((char)bytes[i]);
        }
        String content = byteArray.toString();
        return content;
    }

    private boolean isJabxObject(Object payload) {
        return payload.getClass().isAnnotationPresent(XmlType.class);
    }

    private String getJaxbContentAsString(Object jaxbObject, String outputEncoding) {
        String content;
        if (this.jaxbToXml == null && this.jaxbContext == null) {
            content = "Missing jaxbContext or deprecated jaxb2xml injection, can't marshal JAXB object of type: " + jaxbObject.getClass().getName();
        } else {
            if (!jaxbObject.getClass().isAnnotationPresent(XmlRootElement.class)) {
                QName wrapperQName = new QName("class:" + jaxbObject.getClass().getName(), this.getJaxbWrapperElementName(jaxbObject));
                jaxbObject = new JAXBElement(wrapperQName, jaxbObject.getClass(), null, jaxbObject);
            }
            try {
                content = this.jaxbContext != null ? this.marshalJaxbObject(jaxbObject) : (String)this.jaxbToXml.transform(jaxbObject, outputEncoding);
            }
            catch (TransformerException e) {
                e.printStackTrace();
                content = "JAXB object marshalling failed: " + e.getMessage();
            }
        }
        return content;
    }

    private String marshalJaxbObject(Object jaxbObject) {
        try {
            StringWriter writer = new StringWriter();
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.marshal(jaxbObject, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private String getJaxbWrapperElementName(Object payload) {
        String name = payload.getClass().getSimpleName();
        String elementName = name.substring(0, 1).toLowerCase() + name.substring(1);
        return elementName;
    }

    static {
        try {
            HOST = InetAddress.getLocalHost();
            HOST_NAME = HOST.getHostName();
            HOST_IP = HOST.getHostAddress();
            PROCESS_ID = ManagementFactory.getRuntimeMXBean().getName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

