/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.test;

import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.soitoolkit.commons.mule.test.AbstractJmsTestUtil;

public class ActiveMqJmsTestUtil
extends AbstractJmsTestUtil {
    private static final String USR = ActiveMQConnection.DEFAULT_USER;
    private static final String PWD = ActiveMQConnection.DEFAULT_PASSWORD;
    protected String qmUrl = null;

    public ActiveMqJmsTestUtil(String qmUrl, String clientId) {
        this.qmUrl = qmUrl;
        this.init(clientId);
    }

    public ActiveMqJmsTestUtil(String qmUrl) {
        this(qmUrl, null);
    }

    public ActiveMqJmsTestUtil() {
        this("vm://localhost");
    }

    @Override
    protected QueueConnectionFactory createQueueConnectionFactory() throws Exception {
        logger.debug("Creating ActiveMQ Queue Connection Factory using URL: {}", (Object)this.qmUrl);
        return new ActiveMQConnectionFactory(USR, PWD, this.qmUrl);
    }

    @Override
    protected TopicConnectionFactory createTopicConnectionFactory() throws Exception {
        logger.debug("Creating ActiveMQ Topic Connection Factory using URL: {}", (Object)this.qmUrl);
        return new ActiveMQConnectionFactory(USR, PWD, this.qmUrl);
    }

    @Override
    protected String getUsername() {
        return USR;
    }

    @Override
    protected String getPassword() {
        return PWD;
    }

    @Override
    public int getNoOfMsgsIncludingPendingForRetry(String queue) {
        return this.browseMessagesOnQueue(queue).size();
    }
}

